h45117
s 00007/00020/00020
d D 2.1 86/01/30 16:38:17 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00040/00000/00000
d D 1.1 85/11/05 16:44:53 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include <ctype.h>
#include <carl/defaults.h>

double Rel_func(f, x)
D 2
	register Function *f; 
	register double x;
E 2
I 2
	register Function *f;	/* Function to index */
	register double x;	/* floating-point index */
E 2
/*
D 2
 * Index Function by unit interval index.
 * .TP 10
 * Takes:
 * .TP 10
 * f
 * Function to index,
 * .TP 10
 * x
 * floating-point index.
 * .TP 10
 * Returns:
 * value of function at that index, or 0 on errors.
 * .TP 10
 * Side effects:
 * Sets Player_stat to P_NULL_PTR if f == NULL, and returns 0.0.
 * .TP 10
 * notes:
 * The function is taken as having a range of [0,1-epsilon].
E 2
I 2
 * Index a Function by unit interval index.
 * .LP
 * Returns value of function at that index, or 0 on errors.
 * Sets 'Player_stat' to 'P_NULL_PTR' if 'f == NULL', and returns 0.0.
 * The function is taken as having a range of [0,1\(mi`epsilon`].
E 2
 * Function value computed by linear interpolation as necessary.
 * Indicies outside the [0,1) interval are truncated.
 */
{
	Player_stat &= ~P_NULL_PTR;
	if (f == NULL) {
		fprintf(stderr, "rel_func: NULL function!\n");
		Player_stat |= P_NULL_PTR;
		return(0.0);
	}
	return(Func(f, x * f->flen));
}
E 1
