h35943
s 00019/00029/00054
d D 2.2 86/01/30 16:32:16 dgl 6 5
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00007/00007/00076
d D 2.1 85/10/26 23:38:20 dgl 5 4
c changed variable names.
e
s 00007/00006/00076
d D 1.4 85/10/14 15:40:52 dgl 4 3
c prettified P_FLOAT code.
e
s 00001/00001/00081
d D 1.3 85/10/01 16:36:38 dgl 3 2
c call to mk_Player revised.
e
s 00020/00012/00062
d D 1.2 85/09/20 16:14:21 dgl 2 1
c exit() is now Pexit().
e
s 00074/00000/00000
d D 1.1 84/12/21 12:02:10 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
I 2

/* take away NOTDEF to have integer debugging */
# ifdef NOTDEF
# ifdef P_INTEGER
# define P_DEBUG
int _Pdebug;
# endif P_DEBUG
# endif NOTDEF

E 2
#include "debug.h"
#define NULL 0

I 6
Player * New_player(proc, beg, dur, stat)
	register Player (*proc)();	/* address of Player procedure */
	register P_TYPE beg,		/* begin time */
			dur;		/* duration */
	register int stat;		/* running status */
E 6
/*
D 6
 * New_Player - instantiate new Player instance 
 * takes:
 * 	proc -	address of Player procedure
 * 	beg -	begin time of Player instance
 * 	dur -	duration of Player instance
 * 	stat -	run status of Player instance
 * returns:
 * 	address of new Player instance data structure
 * side effects:
 * 	Installs Player template on ST_INSTANCE symbol table.
 * 	Links it to list of Player instances.
 * 	Queues it to run at the stated begin time.
 * diagnostics:
 * 	New_player: no class template for <PLAYER>
 * 	New_Player: backward time reference=<TIME> for Player <PLAYER>
 * 	
E 6
I 6
 * Instantiate new Player.
 * .LP
 * Running status of Player instance is typically 
 * \fBP_READY\fP or \fBP_STOPPED\fP.
 * Returns
 * address of new Player instance data structure.
 * Links instance to list of Player instances of this class.
 * Queues it to run at the stated begin time if status is \fBP_READY\fP.
 * Diagnostics:
 * `New_player: no class template for <Player>`.
 * .br
 * `New_Player: backward time reference=<TIME> for Player <PLAYER>.`
E 6
 */
D 6

I 4
# ifdef P_FLOAT
#	define TYPE double
# else P_FLOAT
#	define TYPE long
# endif P_FLOAT

E 4
Player *
New_player(proc, beg, dur, stat)
	register Player (*proc)();
D 4
# ifdef P_FLOAT
	register double beg, dur;
# endif P_FLOAT
# ifdef P_INTEGER
	register long beg, dur;
# endif P_INTEGER
E 4
I 4
	register TYPE beg, dur;
E 4
	register int stat;
E 6
{
	extern Player *get_templ();
	register Player *c, *i;

	c = get_templ(proc);
	if (c == NULL) {
# ifdef P_FLOAT
		fprintf(stderr, "New_player: no class template for %x\n", c);
I 2
# else P_FLOAT
		printf("New_player: no template\n");
E 2
# endif P_FLOAT
D 2
		exit(1);
E 2
I 2
		Pexit(1);
E 2
	}
D 3
	if ((i = mk_Player(&ilist)) == NULL)
E 3
I 3
	if ((i = mk_Player(c)) == NULL)
E 3
D 2
		exit(1);
E 2
I 2
		Pexit(1);
E 2
D 5
	(*c->iproc)(i, c);		/* setup instance structure */
E 5
I 5
	(*c->P_iproc)(i, c);		/* setup instance structure */
E 5
	if (beg < Now)			/* force no backwards time refs. */
		beg = Now;
D 5
	i->beg = i->ptime = beg;
	i->dur = dur;
	i->runstat = stat;
	i->caller = Self;
E 5
I 5
	i->P_beg = i->P_time = beg;
	i->P_dur = dur;
	i->P_runstat = stat;
	i->P_caller = Self;
E 5
	if (Self != NULL)
D 5
		Self->n_children++;
E 5
I 5
		Self->P_children++;
E 5
D 2
	if (beg < Now) {
# ifdef P_FLOAT
		fprintf(stderr,
		    "New_Player: backward time reference=%f for Player %s\n",
		    beg, i->name);
# endif P_FLOAT
		exit(1);
	}
E 2
D 6
	set_wait(i, beg);
E 6
I 6
	if (stat == P_READY)
		set_wait(i, beg);
E 6
I 2

E 2
# ifdef P_DEBUG
	if (_Pdebug & NEW_PLAYER)
I 2
# ifdef P_FLOAT
E 2
		fprintf(stderr,
D 2
		"New_player: %s, stat=%d, beg=%d, dur=%d, Now=%d\n",
			i->name, i->runstat, i->beg, i->dur, Now);	
E 2
I 2
# else P_FLOAT
		fprintf(1,
# endif P_FLOAT
			"New_player: %s, stat=%d, beg=%d, dur=%d, Now=%d\n",
D 5
				i->name, i->runstat, i->beg, i->dur, Now);	
E 5
I 5
				i->P_name, i->P_runstat, i->P_beg, i->P_dur, Now);	
E 5
E 2
# endif P_DEBUG
	return(i);
}
E 1
