h61212
s 00021/00017/00024
d D 2.2 86/01/30 16:32:06 dgl 3 2
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00009/00009/00032
d D 2.1 85/10/26 23:38:13 dgl 2 1
c changed variable names.
e
s 00041/00000/00000
d D 1.1 84/12/21 12:01:55 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include "debug.h"
#define NULL 0
D 3
/*
 * Kill - terminate a process with extreme prejudice
 * Takes:
 * 	Player *x -	points to Player instance to be terminated
 * returns:
 * 	0 on success, -1 on errors
 * side effects:
 * 	If a parent process is waiting to be notified of the termination
 * 	of children, that parent is scheduled to run.  See Join()
 * 	for an explanation of conditions for this.
 *	The parent's status field, indicating the request to be run
 *	on child termination, will be cleared if there are no more
 *	children to wait on.
 * 	
 */
E 3

Kill(x)
D 3
	register Player *x;
E 3
I 3
	register Player *x;	/* pointer to Player instance */
/*
 * Terminate a Player instance with extreme prejudice.
 * .LP
 * Takes
 * pointer to Player instance to be killed.
 * Returns
 * 0 on success, \-1 on errors, which include being passed
 * a null pointer, and if the running status of the Player is
 * already P_KILLED.
 * .LP
 * If a parent process is waiting to be notified of the termination
 * of children, that parent is scheduled to run.  See \fBJoin()\fP
 * for an explanation of conditions for this.
 * The parent's status field, indicating the request to be run
 * on child termination, will be cleared if there are no more
 * children to wait on.
 */
E 3
{
D 3
	if (x == NULL)
E 3
I 3
	if (x == NULL) 
E 3
		return(-1);
I 3
	if (x->P_runstat == P_KILLED)	/* already killed? */
		return(-1);	/* "I regret that I have but one life..." */
E 3
D 2
	x->runstat = P_KILLED;
	if (x->caller != NULL) {
		if (x->caller->child_wait == EACH_CHILD)
			set_wait(x->caller, Now);
		if (--x->caller->n_children == 0) {
			if (x->caller->child_wait == ALL_CHILDREN) {
				x->caller->ptime = Now;
				set_wait(x->caller, Now);
E 2
I 2
	x->P_runstat = P_KILLED;
	if (x->P_caller != NULL) {
		if (x->P_caller->P_child_wait == EACH_CHILD)
			set_wait(x->P_caller, Now);
		if (--x->P_caller->P_children == 0) {
			if (x->P_caller->P_child_wait == ALL_CHILDREN) {
				x->P_caller->P_time = Now;
				set_wait(x->P_caller, Now);
E 2
			}
D 2
			x->caller->child_wait = 0;
E 2
I 2
			x->P_caller->P_child_wait = 0;
E 2
		}
	}
	garbage(x);
	return(0);
}
E 1
