h35021
s 00007/00015/00021
d D 2.1 86/01/30 16:39:48 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00036/00000/00000
d D 1.1 85/11/06 12:38:29 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

extern double Scale[];

double Key(str)
D 2
	register char *str;
E 2
I 2
	register char *str;	/* pointer to Pitch expression string */
E 2
/*
D 2
 * Evaluate string as Pitch expression, return piano key index.
 * .TP
 * Takes:	
 * pointer to Pitch expression string.
 * .TP
 * Returns:	
 * pitch in semitones above A0.
 * .TP
 * Side effects: 
 * Sets Player_stat: to P_REST_SET if expr == RESTR.
 * .TP
 * Notes:	
 * Does not recognize Stop, Kill, or Hold.
 * Returns 1.0 if expression == RESTR.
E 2
I 2
 * Evaluate string as \fBPitch\fP expression, return piano key index.
 * .LP
 * Returns pitch in semitones above piano \fIA0\fP.
 * Sets \fBPlayer_stat\fP: to \fBP_REST_SET\fP 'if expr ==' \fBRESTR\fP.
 * Does not evaluate \fBStop\fP, \fBKill\fP, or \fBHold\fP.
 * Returns 1.0 'if expression ==' \fBRESTR\fP.
E 2
 */
{
	float oct;
	register int pc = pc_oct(str, &oct, NULL);

	if (Player_stat & P_REST_SET|P_EXPR_ERR == 0)
		return(pc + (PITCHES * (oct + 4.0)));
	else
		return(1.0);
}
E 1
