h64721
s 00006/00018/00051
d D 2.1 86/01/30 16:38:22 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00069/00000/00000
d D 1.1 85/11/05 16:45:01 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include <ctype.h>
#include <carl/defaults.h>

double Func(f, x)
D 2
	register Function *f; 
	register double x;
E 2
I 2
	register Function *f;	/* Function to be indexed */
	register double x;	/* floating-point index */
E 2
/*
 * Return the y-value for the value on the Function at x.  
D 2
 * .TP 10
 * Takes:
 * .RS
 * .TP 10
 * f
 * Function to be indexed,
 * .TP 10
 * x
 * floating-point index.
 * .RE
 * .TP 10
 * Returns:
 * 	value of function at that index.
 * .TP 10
 * Notes:
E 2
I 2
 * .LP
 * Returns
 * value of function at that index.
E 2
 * If x has a fractional part, linear interpolation is used to find 
 * the value.
D 2
 * Works for both H_MONO_IN_X and H_XY_PAIRS.
E 2
I 2
 * Works for both 'H_MONO_IN_X' and 'H_XY_PAIRS'.
E 2
 */
{
	register long ind;
	register double frac;

	if (f == NULL) {
		fprintf(stderr, "func: NULL function!\n");
		Player_stat |= P_NULL_PTR;
		return(0.0);
	} else
		Player_stat &= ~P_NULL_PTR;
	if (!strcmp(f->ftype, H_MONO_IN_X)) {
		ind = x;
		frac = x - ind;
		if (ind >= f->flen-1)
			return(f->fyval[f->flen-1]);
		if (ind < 0)
			return(f->fyval[0]);
		else
			return((1.0 - frac) * f->fyval[ind] 
				+ frac * f->fyval[ind+1]);
	}
	else
	if (!strcmp(f->ftype, H_XY_PAIRS)) {
		register double Y1, Y2, X1, X2; 

		for (ind = 0; ind < f->flen-1; ind++) {
			if (f->fxval[ind] > x) {
				break;
			}
		}
		X2 = f->fxval[ind];
		Y2 = f->fyval[ind];
		X1 = f->fxval[ind-1];
		Y1 = f->fyval[ind-1];
		frac = (x - X1)/(X2 - X1);
		return((1.0 - frac) * Y1 + frac * Y2);
	}
	return(0.0);
}
E 1
