include(/usr/local/include/carl/config.m4)dnl

PROG =		libPlayer
CFLAGS =	-g -DP_FLOAT
.SUFFIXES:      .P
.P.o:           ;Player -P $*.P && cc -c ${CFLAGS} $*.c

DESTDIR =	m4DESTDIR
LIBDIR =	m4LIBDIR
OBJS =		Abs_time.o\
		Alias.o\
		Beg_time.o\
		Caller.o\
		Direction.o\
		Dur_time.o\
		End_time.o\
		Expr.o\
		Exprs.o\
		Find_measure.o\
		Func.o\
		Func_length.o\
		Gen.o\
		Get_keysig.o\
		Get_list.o\
		Get_metronome.o\
		Get_pname.o\
		Get_paddr.o\
		Get_timesig.o\
		Hipn.o\
		Index.o\
		Instances.o\
		Join.o\
		Key.o\
		Keys.o\
		Kill.o\
		Kill_test.o\
		Motive.o\
		New_player.o\
		Octave.o\
		Oct_pt.o\
		Oct_pts.o\
		P.o\
		Peekcl.o\
		Pexit.o\
		Pitch.o\
		Pitches.o\
		Player_status.o\
		Pmain.o\
		Pp.o\
		Print_stat.o\
		Ps.o\
		Psleep.o\
		Read_func.o\
		Read_list.o\
		Read_lists.o\
		Rel_func.o\
		Rel_time.o\
		Rest.o\
		Resting.o\
		Rhythm.o\
		Rhythms.o\
		Set_beg_time.o\
		Set_dur_time.o\
		Set_p.o\
		Set_pi.o\
		Set_pp.o\
		Set_ps.o\
		Setup_p.o\
		Setup_pp.o\
		Setup_ps.o\
		Silent.o\
		Start.o\
		Stop.o\
		Strings.o\
		SubPname.o\
		Tempo.o\
		Tmap.o\
		Unrest.o\
		Unsilent.o\
		Unwait_until.o\
		Wait_for.o\
		Wait_until.o\
		add_player.o\
		check_waits.o\
		ckmaxp.o\
		clist_direct.o\
		cmusout.o\
		cpy_args.o\
		cyclist.o\
		do_rhy.o\
		garbage.o\
		get_templ.o\
		globs.o\
		hi_p_ck.o\
		interplist.o\
		keysig.o\
		malerr.o\
		metronome.o\
		mk_Player.o\
		parse_flags.o\
		pc_oct.o\
		pexprerr.o\
		poll_waits.o\
		read_notes.o\
		read_stdin.o\
		resize_p.o\
		run_arbiter.o\
		scanargs.o\
		sched.o\
		symtab.o\
		symtab_stat.o\
		timesig.o

do_it:		m4INCLUDE/Player.h ${PROG}

m4INCLUDE/Player.h:	Player.h
		cp Player.h m4INCLUDE

${OBJS}:	m4INCLUDE/Player.h 

${PROG}: 	${OBJS}
		ar uv ${PROG}.a ${DBUG} ${OBJS}

install:
		cp ${PROG}.a ${LIBDIR}/${PROG}.a
		ranlib ${LIBDIR}/${PROG}.a

clean:
		rm -f poll_waits.c read_stdin.c
		rm -f ${PROG}.a ${DBUG} ${OBJS} *.3 a.out core

Pitches.o:	Scale.h

#.c.o:
#		${CC} ${CFLAGS} -c $*.c
#		-ld -x -r $*.o
#		mv a.out $*.o

pub:
		rm -f m4SRCDIR/lib/${PROG}/*
		cp Makefile.m4 *.[cfpshly] m4SRCDIR/lib/${PROG}

MANDIR	= ../man
MAN	= $(MANDIR)/man3
MANPAGES = Pitches.3 Wait_until.3 Abs_time.3 Func.3 P.3 Pmain.3
CTAGS	= /usr/sun/bin/ctags

Cindex: *.h *.c; ${CTAGS} *.h *.c ; ${CTAGS} -x *.h *.c > Cindex
manpages: $(MANPAGES)

makeman = ./makeman
Pitches.3: Cindex; $(makeman) -d "Player cyclic list routines" Pitches \
	Pitches Keys Rhythms Oct_pts Exprs Strings Index \
	Pitch Key Rhythm Oct_pt Expr Octave Direction \
	Get_list Get_metronome Get_keysig Get_timesig Motive Peekcl \
	Read_list Read_lists Find_measure

Wait_until.3: Cindex; $(makeman) -d "Player scheduling routines" Wait_until \
	Wait_until Wait_for Unwait_until Unwait_for Join Kill \
	Kill_test New_player

Abs_time.3: Cindex; $(makeman) -d "Player time status & control" Abs_time \
	Abs_time Beg_time Dur_time End_time Rel_time \
	Set_beg_time Set_dur_time Tempo 

Func.3: Cindex; $(makeman) -d "Player Function routines" Func \
	Func Func_length Gen Read_func Rel_func

P.3: Cindex; $(makeman) -d "Player P-field status, value & control" P \
	P Pp Ps Set_p Set_pp Set_ps Setup_p Setup_pp Setup_ps

Pmain.3: Cindex; $(makeman) -d "Player general status & control" Pmain \
	Pmain Pexit \
	Alias Caller Get_paddr Get_pname \
	Hipn Player_status \
	Print_stat Instances Psleep Rest Resting Silent Start Stop \
	Unrest Unsilent 

installman: $(LIBNAME)
	cd $(MAN); /bin/rm -f $(MANPAGES)
	ln $(MANPAGES) $(MAN)

tags: *.c *.h; ${CTAGS} *.h *.c
