#include <stdio.h>
#include <carl/carl.h>
#include <carl/defaults.h>

/*
 * read_func_file - demo program for read_func_file(3carl)
 * takes unix file name as containing floatsam function data.
 * If the data has a header that has the H_SEQUENCE property,
 * that property will have one of two values, H_MONO_IN_X, or
 * H_XY_PAIRS.  The header property will determine the shape of
 * the FUNCTION structure returned by read_func_file().  In particular,
 * the x->ftype field will contain the string value of H_MONO_IN_X,
 * or H_XY_PAIRS as defined in <carl/defaults.h>.  If it is H_MONO_IN_X,
 * the x->fyval array will contain the floatsams read in, and x->fxval
 * will be NULL, otherwise if it is H_XY_PAIRS, x->fxval will contain the
 * x points corresponding to x->fyval.
 * 
 * If there is no header, the format of the function will be determined
 * by the second argument to read_func_file(). If it is H_XY_PAIRS,
 * data will be so interpreted in the absence of a header.
 */

main(argc, argv)
	char **argv;
{
	int i;
	FUNCTION *x;

	if (argc > 1)
		x = read_func_file(argv[1], H_XY_PAIRS);
	else
		exit(1);
	printf("name=%s\n", x->fname);
	printf("type=%s\n", x->ftype);
	printf("len=%d\n", x->flen);
	if (!strcmp(x->ftype, H_MONO_IN_X)) {
		for (i = 0; i < x->flen; i++)
			printf("y[%d]=\t%f\n", i, x->fyval[i]);
	} else {
		for (i = 0; i < x->flen; i++)
			printf("x[%d]=\t%f\ty[%d]=\t%f\n", 
				i, x->fxval[i],
				i, x->fyval[i]);
	}
	exit(0);
}
