#include <stdio.h>
#include <carl/carl.h>
#include <carl/procom.h>
#include <carl/defaults.h>

/*
 * mkstdhead - make default standard header
 * This bundles up arguments from the command line into a header,
 * then copies any floatsams from its stdin to stdout.  Any header
 * on stdin is not copied to stdout.
 * arguments:
 * 	mkstdheader [filename [sample_rate [channels [packing_mode]]]
 * arguments not supplied are filled in by defaults
 * Note: the "filename" is simply a string that is passed in the header.
 * Its significance is arbitrary to the communicating programs, 
 * as is indeed the rest of the information in the header as well.
 */

main(argc, argv)
	char **argv;
{
	register float x;
	register int otty = isatty(1), cnt = 0;
	register char *c;

	while (argc < 5) {	/* fill in defaults */
		switch (argc++) {
			case 1:
				argv[1] = "test";
				break;
			case 2:
				argv[2] = DHISR;
				break;
			case 3:
				argv[3] = "1";
				break;
			case 4:
				argv[4] = H_FLOATSAM;
				break;
			}
	}

	if (stdheader(stdout, argv[1], argv[2], argv[3], argv[4])) {
		fprintf(stderr, "stdheader failed\n");
		exit(1);
	}
	noautocp();
	if (putheader(stdout)) {
		fprintf(stderr, "putheader failed\n");
		exit(1);
	}
	if ((c = getprop(stdout, H_FORMAT)) == NULL) {
		fprintf(stderr, "no data format specification\n");
		exit(1);
	}
	if (!strcmp(H_FLOATSAM, c)) {
		while (getfloat(&x) > 0) {
			if (otty)
				printf("%d:\t%f\n", cnt++, x);
			else
				putfloat(&x);
		}
		if (!otty)
			flushfloat();
	} else {
		while (getshort(&x) > 0) {
			if (otty)
				printf("%d:\t%d\n", cnt++, x);
			else
				putshort(&x);
		}
		if (!otty)
			flushshort();
	}
	exit(0);
}
