h17324
s 00069/00000/00000
d D 1.1 84/07/25 14:31:41 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <sys/file.h>
#include <carl/libsf.h>

/* 
 * newsf - prepare new sfd for opensf.
 * This routine takes an sfd set by the user for all appropriate modes
 * and fills in the rest of the stuff the system needs to know about it.
 * Then if file is realtime, the number of cylinders requested is claimed.
 * Creation date is set, sfd->fs is initialized, sfd->err is cleared,
 * and sfd is returned.
 */

struct sndesc  *
newsf (sfd)
	struct sndesc  *sfd;
{
	extern char   *getprown (), *getsfn ();
	extern struct dskblk  *allocsf ();
	extern long    time ();
	char   *d;
	register int    errz;

	if (errz = checksfd (sfd)) {
		fprintf (stderr,
			"newsf: error making new soundfile, sfd error = %o\n",
			(sfd == NULL) ? 0 : errz);
		return (NULL);
	}

	 /* does such a path exist? */
	if (ckpath (sfd -> sfn) != 0) {		/* yes it does */
		d = getsfn (sfd -> sfn, 1);	/* strip body */
		fprintf (stderr, "newsf: %s no such sound file path.\n", d);
		return (NULL);
	}

	 /* note when it was created */
	sfd -> adate = sfd -> rdate = sfd -> cdate = time ((long *) NULL);
	 /* do this before call to allocsf, which writes date in dskcyls */

	 /* did user supply a file owner? */
	if (sfd -> sfown != NULL && (strlen (sfd -> sfown) > 0)) {
	/* fine we'll use theirs. */
	}
	else
		sfd -> sfown = getprown ();

	if (sfd -> rtflag == RT) {
		sfd -> cp = allocsf (sfd, sfd -> ncyls, -1L, 
			(struct dskblk *) NULL);
		if (sfd -> cp == NULL) {
		    fprintf (stderr,
		       "newsf: no room for %d contiguous cylinders for file %s",
			sfd -> ncyls, sfd -> sfn);
		    return (NULL);
		}
		if (sfd -> ncyls == 0)
			sfd -> ncyls = sfd -> cp -> len;
	}
	else {
		sfd -> ncyls = 0;
		sfd -> cp = NULL;
	}
	sfd -> fs = 0;		/* truncate length to 0 */
	sfd -> err = 0;		/* clear any errors */
	return (sfd);
}
E 1
