/* whead.c	1.2	(CARL)	11/19/84	16:06:27 */
#include <stdio.h>
#include <carl/sndio.h>
#include <carl/carl.h>
#include <carl/defaults.h>
#include <carl/procom.h>

whead(sfd, chanspec, opak)
	CSNDFILE *sfd;
	char *chanspec, opak;
{
	struct csnd_prop *prop;
	char srate[16], nchans[16], *format;
	int cnt;

	(void) sprintf(srate, "%f", sfd->sr);
	for (cnt = 0; chanspec != NULL && chanspec[cnt] != '\0'; cnt++)
		/* empty */ ;
	if (cnt == 0)
		cnt = sfd->nc;
	(void) sprintf(nchans, "%d", cnt);
	if (opak == PM16BIT)
		format = H_SHORTSAM;
	else
		format = H_FLOATSAM;

	if (stdheader(stdout, sfd->sfn, srate, nchans, format)) {
		fprintf(stderr, "stdheader failed\n");
		return(-1);
	}

	for (prop = sfd->csnd_p; prop != NULL; prop = prop->cprop_next)
		addprop(stdout, prop->cprop_name, prop->cprop_val);

	if (putheader(stdout)) {
		fprintf(stderr, "putheader failed\n");
		return(-1);
	}
	if (flushfloat() < 0) {
		fprintf(stderr, "flushfloat failed\n");
		return(-1);
	}
	return(0);
}
