/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>
#define BUFSIZE	4096
#define min(a,b) ((a)<(b)?(a):(b))

extern int sferror;
extern long filsfb();	/* from libsf */
extern char *chans;	/* from setchan() */
extern char *chanspec;	/* from sndin */
extern int otty;

/* 
 * stof - short to float conversion
 * begin and end are sample frames 
 */


stof(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	if (otty) {
		if (tstof(sfd, begin, end) != 0)
			return(sferror);
	} else {
		if (chanspec == NULL) {
			if (fncstof(sfd, begin, end) != 0)
				return(sferror);
		} else {
			if (fcstof(sfd, begin, end) != 0)
				return(sferror);
		}
	}
	return(0);
}

/*
 * fcstof - short to floating point, channel selected i/o
 * this is faster than the routines for float to float or short to short
 * which should be rewritten to conform to this
 */

fcstof(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	register long i, x, nsib, nc;
	register double sscale = 32767.0;
	register short *sp;
	float buffer[BUFSIZE / sizeof(float)];
	register int sf_fpos = 0,
		bs = BUFSIZE / sizeof(float),
		y = -1; 

	if (getsfbuf(sfd)) { 
		sferror = -1; 
		return(-1); 
	}
	sp = sfd->sb;
	nc = sfd->nc;
	nsib = sfd->nsib;
	begin *= nc;
	end *= nc;
	begin = begin > 0 ? begin : 0;
	end = min(sfd->fs, end);

	for (i = begin; i < end; i++, x++) {
		register long block; 

		if (!chans[++y >= nc ? (y = 0) : y]) 
			continue;
		if ((block = i / nsib) != sfd->secptr) {
			if ((sfd->secptr = filsfb(sfd, block)) < 0) { 
				sferror = SFBNDER; 
				break; 
			}
			x = i % nsib;
		}

		*(buffer+sf_fpos++) = *(sp+x)/sscale;
		if (sf_fpos >= bs) {
			if (write(1, (char *) buffer, BUFSIZE) <= 0) {
				sferror++;
				break;
			}
			sf_fpos = 0;
		}
	}
	if (sf_fpos > 0)
		if (write(1, (char *) buffer, sf_fpos*sizeof(float)) <= 0)
			sferror++;
	return(sferror);
}

/*
 * fncstof - no channel spec, short to float conversion
 * This is faster than the routines for float to float or short to short,
 * which should be rewritten on this model.
 */

fncstof(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	register long i;
	register float sscale = 32767.0;
	register short *sp;
	register long nsib;
	register int sf_fpos = 0;
	float buffer[BUFSIZE / sizeof(float)];
	register int bs = BUFSIZE / sizeof(float);

	if (getsfbuf(sfd)) { 
		sferror = -1; 
		return(-1); 
	}
	sp = sfd->sb;
	nsib = sfd->nsib;
	begin *= sfd->nc;
	end *= sfd->nc;
	begin = begin > 0 ? begin : 0;
	end = min(sfd->fs, end);

	for (i = begin; i < end; i++) {
		register long x;
		register long block; 

		if ((block = i / nsib) != sfd->secptr) {
			if ((sfd->secptr = filsfb(sfd, block)) < 0) { 
				sferror = SFBNDER; 
				break; 
			}
			x = i % nsib;
		}

		*(buffer+sf_fpos++) = *(sp+x++)/sscale;
		if (sf_fpos >= bs) {
			if (write(1, (char *) buffer, BUFSIZE) <= 0) {
				sferror++;
				break;
			}
			sf_fpos = 0;
		}
	}
	if (sf_fpos > 0)
		if (write(1, buffer, sf_fpos*sizeof(float)) <= 0)
			sferror++;
	return(sferror);
}

tstof(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	register long i;
	register float sscale = 32767.0;
	register short *sp;
	register int nsib, nc;
	register int y = -1;

	if (getsfbuf(sfd)) { 
		sferror = -1; 
		return(-1); 
	}
	sp = sfd->sb;
	nc = sfd->nc;
	nsib = sfd->nsib;
	if (chanspec)
		end *= nc;
	begin *= nc;
	end *= nc;
	begin = begin > 0 ? begin : 0;
	end = min(sfd->fs, end);

	for (i = begin; i < end; i++) {
		register long x;
		register long block; 

		if (!chans[++y >= nc ? (y = 0)  : y]) 
			continue;
		block = i / nsib;			
		if (block != sfd->secptr) 
		    if ((sfd->secptr = filsfb(sfd, block)) < 0)
			    { sferror = SFBNDER; break; }
		x = i % nsib;	/* get samp in buf */

		printf("%d\t%f\n", i, *(sp+x)/sscale);
	}
	return(sferror);
}
