/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
# include <sys/types.h>
#include <carl/sndio.h>

#define TRUE 1
#define FALSE 0
#define IGNORE TRUE
#define DONT_IGNORE FALSE
#define FLOATOSIZ float		/* size of default output sample */
#define SHORTOSIZ short
#define FLOATOPAK "f"
#define SHORTOPAK 's'
char *opak = "f";

char *usage=
"[flags] [begin time] [end time] [file]\n flags: flag = usage (value, value... : default)\n o = output packing (s,f: f)\n b = set begin time\n e = set end time\n d = set duration\n";


main(argc, argv)
    	int argc; char *argv[];
{
	extern long lmin(), sndi();
	extern char *malloc();
    struct sndesc *sfd, *sfiargs();
    float *buf;
    long i, st, end, rtn, blen, xfrsiz; 
    /* these set default output format */
    int obps = sizeof(FLOATOSIZ);	/* i/o bytes per sample */
    int ibps = sizeof(short);
    char *name = "test";
    int ign = DONT_IGNORE;

    sfsetiname(argv[0]);		/* pass name to interrupt routines */
    sfd = sfiargs(argc, argv, &opak, &st, &end, name, usage, ign);
    if (sfd == NULL) 
	exit(1);
    /* calculate buffer sizes */
    if (sfd->pm == PM16BIT) { 
	    ibps = BP16BIT; 
	    xfrsiz = sfd->bufsiz / sizeof(short); 
    } else { 
	    ibps = BPFLOAT; 
	    xfrsiz = sfd->bufsiz / sizeof(float); 
    }
    buf = (float *) malloc((unsigned) sfd->bufsiz*obps/ibps); 

    /* read in chunks of sound, maximum size = xfrsiz, minimum = end - i */
    inihist();
    for (   i = st, blen = lmin(xfrsiz, end - i); 
	    blen > 0 && sfd->eof == FALSE;
	    i += blen, blen = lmin(xfrsiz, end - i)
	    ) 
	{
	rtn = sndi(sfd, buf, i, blen, opak);
	if (rtn < 0) 
		break;
	hist(buf, blen);
	}
    endhist();
    if (sclosesf(sfd)) {
	fprintf(stderr, "sndhist: error closing file\n");
	exit(1);
    }
    exit(0);
}


psbuf(buf, st, blen, sr, nc)
	short *buf; long st; int blen; float sr; int nc;
{
    static int first;
    register long j;
    register int is;

    if (!first) 
	{ 
	first++;
	printf("sample\ttime\tdec\thex\toctal\n");
	}

    for (j = 0; j < blen; j++)	/* format for tty output */ 
	{
	is = *(buf+j);
	printf("%d:\t%5.4f\t%6d\t0x%04x\t0%06o\n",
		(j + st) / nc,
		(j + st)/(sr * nc),
		is,
		is & ((u_short) -1), 
		is & ((u_short) -1)); 
	}
    }
