h03624
s 00009/00009/00144
d D 1.3 84/09/05 16:19:29 root 3 2
c Mark: Added -a flag for the third and final time!
e
s 00025/00019/00128
d D 1.2 84/09/01 23:33:15 root 2 1
c added -a flag, changed some constants to agree with the type
c of variable they were compared against, and modified usage()
e
s 00147/00000/00000
d D 1.1 84/07/25 14:30:53 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/carl.h>
#include <carl/sndio.h>
#include <math.h>

extern int sferror;
D 2
extern CSNDFILE *rootsfd;
E 2
I 2
extern CSNDFILE *rootsfd, *opensf();
E 2
/* these two from crack.c */
extern int arg_index;
extern char *arg_option;
D 2
extern float sfexpr();
E 2
I 2
extern float sfexpr(), fsndi();
E 2

main(argc, argv)
	char **argv;
{
D 2
	int otty = isatty(1); 
E 2
I 2
	CSNDFILE *sfd;
D 3
	int otty = isatty(1), maxset = 0; 
E 3
I 3
	int otty = isatty(1);
E 3
E 2
	long i;
	float output; 	/* output can't be register variable */
D 2
	float fsndi(), max = -HUGE; 
	CSNDFILE *sfd, *opensf();
E 2
I 2
D 3
	float max = -HUGE; 
E 3
I 3
	float max = -HUGE, amax = 1.; 
E 3
E 2
	long end = 0, begin = 0; 
	char *cbeg = NULL, *cend = NULL, *cdur = NULL, *file = "test", ch;

	/* get arguments */
D 2
	while ((ch = crack(argc, argv, "b|e|d|h", 1)) != NULL) {
E 2
I 2
	while ((ch = crack(argc, argv, "a|b|e|d|h", 1)) != NULL) {
E 2
		switch (ch) {
I 2
D 3
			case 'a': max = 1.0 / sfexpr(arg_option, 1.0); 
				  maxset++; break;
E 3
I 3
			case 'a': amax = sfexpr(arg_option, 1.0); break;
E 3
E 2
			case 'b': cbeg = arg_option; break;
			case 'e': cend = arg_option; break;
			case 'd': cdur = arg_option; break;
			case 'h': usage(0); break;
			default:  usage(1);
		}
	}
	if (arg_index < argc) 
		file = argv[arg_index];

	/* open sound file */
	if ((sfd = opensf(file, "-r")) == NULL) { 
		fprintf(stderr, "opensf failed on %s\n", file);
		(void) sfallclose(); 
		exit(1); 
	}

	/* calculate times */
	if (cbeg != NULL) 
		begin = sfexpr(cbeg, sfd->sr)*sfd->nc;
	if (cend != NULL)
		end = sfexpr(cend, sfd->sr)*sfd->nc;
	else if (cdur != NULL)
		end = sfexpr(cdur, sfd->sr)*sfd->nc + begin;

	/* check boundaries */
	if (begin < 0 || begin >= sfd->fs) {
		fprintf(stderr, "begin time out of range\n");
		quit();
	}
	if (end < 0 || end >= sfd->fs) {
		fprintf(stderr, "end time out of range\n");
		quit();
	}
	if (end == 0)
		end = sfd->fs;

D 2
	/* calculate normalization factor */
	for (i = begin; i < end; i++) {
		output = fsndi(sfd, i);
		if (sferror) 
			quit();
		if (output < 0)
			output = -output;
		if (output > max)
			max = output;
E 2
I 2
D 3
	if (maxset == 0) { 	/* calculate normalization factor */
E 3
I 3
	/* calculate normalization factor */
E 3
		for (i = begin; i < end; i++) {
			output = fsndi(sfd, i);
			if (sferror) 
				quit();
			if (output < 0.0)
				output = -output;
			if (output > max)
				max = output;
		}
E 2
D 3
	}
E 3

	/* is  max legal? */
D 2
	if (max == 0)
		max = 1;
E 2
I 2
D 3
	if (max == 0.0)
		max = 1.0;
E 3
I 3
	if (max == 0.0){
		fprintf(stderr,"sfnorm: input is all zero!\n");
		quit();
	}
E 3
	else
D 3
		max = 1.0/max;
E 3
I 3
		max = amax / max;
E 3
E 2

	/* output the procom header */
	if (! otty)
		if (mkstdheader(stdout, sfd) != 0)
			exit(1);

	/* normalize and output samples */
	for (i = begin; i < end; i++) {
D 2
		output = fsndi(sfd, i) / max;
E 2
I 2
		output = fsndi(sfd, i) * max;
E 2
		if (sferror) 
			quit();
		if (otty) 
			printf("%d\t%f\n", i, output);
		else 
			putfloat(&output);
	}

	/* force out buffered samples */
	if (!otty) 
		flushfloat();

	/* close all open files */
	(void) sfallclose();
	exit(0);
}

mkstdheader(iop, sfd)
	FILE		*iop;
	CSNDFILE	*sfd;
{
	char		srate[BUFSIZ];
	char		nchans[BUFSIZ];

	(void) sprintf(srate, "%g", sfd->sr);
	(void) sprintf(nchans, "%d", sfd->nc);

	if (stdheader(iop, sfd->sfn, srate, nchans, H_FLOATSAM)) {
		fprintf(stderr, "stdheader failed\n");
		return(-1);
	}

# ifdef notdef
	if (putheader(iop)) {
		fprintf(stderr, "stdheader failed\n");
		return(-1);
	}
# endif

	return(0);
}

quit() {
	fprintf(stderr, "exiting\n");
	(void) sfallclose(); 
	exit(1); 
}

usage(ex)
{
D 2
fprintf(stderr, "%s%s%s%s%s%s",
E 2
I 2
fprintf(stderr, "%s%s%s%s%s%s%s",
E 2
"usage: sfnorm [flags] csound_file > floatsams\n",
" sfnorm writes amplitude-normalized floatsams on standard output\n",
" flags:\n",
I 2
" -aN  normalize to amplitude N\n",
E 2
" -bN  begin at time N\n",
" -eN  end at time N\n",
" -dN  duration is time N\n"
);
exit(ex);
}
E 1
