h56473
s 00001/00001/00068
d D 1.2 84/09/05 16:25:51 root 2 1
c Mark: fixed header copy
e
s 00069/00000/00000
d D 1.1 84/07/25 14:29:36 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/carl.h>
#include <carl/sndio.h>

extern int sferror;

main(argc, argv)
	char **argv;
{
	struct sndesc *opensf(), *sfd;
	float fsndi(), sample;
	long i; 
	int otty = isatty(1);

	if (argc < 2) 
		usage(1);
	if (argv[1][0] == '-')
		usage(1);

	if ((sfd = opensf(argv[1], "-r")) == NULL) 
		exit(1);

D 2
	if (otty) {
E 2
I 2
	if (!otty) {
E 2
		char srate[32], nchans[32];
		sprintf(srate, "%f", sfd->sr);
		(void) sprintf(nchans, "%d", sfd->nc);
		stdheader(stdout, sfd->sfn, srate, nchans, H_FLOATSAM);
	}

	for (i = sfd->fs - 1; i >= 0; i--) {
		sample = fsndi(sfd, i);
		if (sferror) { 
			fprintf(stderr, "retrosf: fsndi error\n");
			(void) closesf(sfd); 
			exit(1); 
		}
		if (otty)
			printf("%d\t%f\n", i, sample);
		else
			putfloat(&sample);
	}
	flushfloat();
	closesf(sfd);
	exit(0);
}

/*
 * sfd->fs 	= (int) total # samples 
 * sfd->nc	= (int) number of channels (starting with 1 for mono)
 * sfd->sr	= (float) sampling rate
 * sfd->sfn	= (char *) sound file name
 * sfd->pm	= (int) packing mode, whether samples are short or float
 * sfd->comment	= (char *) one line comment optionally added by user
 */

/*
 *  For instance, the duration of a file in seconds is:
 *  (sfd->nc * sfd->fs)/sfd->sr
 */

usage(ex)
{
fprintf(stderr, "%s%s",
"usage: retrosf sound_file_name > floatsams\n",
" produces retrograde of a sound file on stdout\n"
);
exit(ex);
}
E 1
