/* purgesf.c	1.2	(CARL)	8/19/84	00:00:56 */
#include <stdio.h>
#include <carl/libsf.h>

/* diread() uses these */
#define DI_ALL 1
#define DI_EXACT 2
#define DI_PARTIAL 4
#define DI_ONEDIR 8

#define DEFCUTOFF 14

/* diread builds string array on these */
extern char **difiles;
extern int difilcnt;
extern int emptdir;


char n1[] = "The following sound files have been unreferenced since:";
char n2[] = "and are therefor subject to purging.";
char d1[] = "The purge is scheduled for:";

main(argc, argv)
	char **argv;
{
	extern char *ctime();
	extern long atol();
	CSNDFILE *accesf(), *sfd;
	int 	i, 
		lf=0, 		/* long format */
		notify=0, 	/* notify format */
		Ulist=0, 	/* list of users affected */
		date=0,		/* sort by date rather than path */
		flag=0,		/* S or H for Scratch or Hold files */
		tflag,
		cnt,
		pcylcnt=0;	/* just print date */
	long cutoff=0, then(), pdate=0;
	long cylcnt = 0;
	char *filsys,  ch;

	while ((ch = crack(argc, argv, "lLt|Nnd|uDSHh", 0)) != NULL) {
		switch (ch) {
			case 'l': lf=1; break;
			case 'L': lf=2; break;
			case 'N': lf=1; notify++; break;
			case 'n': pcylcnt++; break;
			case 'd': 
				lf=1; 
				pdate = then(-atol(arg_option)); 
				break;
			case 'u': Ulist++; break;
			case 't': cutoff = then(atol(arg_option)); break;
			case 'D': date++; break;
			case 'S': /* drops through */
			case 'H': flag = ch; break;
			case 'h': /* drops through */
			default:  usage(1);
		}
	}

	if (cutoff == 0) {
		if (flag == 'S')
			cutoff = then(NSCRAT);
		else if (flag == 'H')
			cutoff = then(NHOLD);
		else
			cutoff = then(DEFCUTOFF);
	}

	if (arg_index < argc)
		filsys = argv[arg_index];
	else
		usage(1);

	if (notify) {
		printf("%s\n", n1);
		printf("%s", ctime(&cutoff));
		printf("%s\n\n", n2);
	}
	if (pdate) {
		printf("%s\n", d1);
		printf("%s\n\n", ctime(&pdate));
	}

	(void) diread(filsys, (char *) NULL, DI_ALL);
	
	if (flag == 0)
		cnt = 2;
	else
		cnt = 1;
	for ( ; cnt > 0; cnt--) {
	    if (flag == 0) {
		if (cnt == 2) {
			tflag = SCRAT;
			cutoff = then(NSCRAT);
		} else {
			tflag = SHOLD;
			cutoff = then(NHOLD);
		}
	    } else
		tflag = flag;
	    for (i = 0; i < difilcnt; i++) {
		if (is_sfn(difiles[i])) {
		    if ((sfd = accesf(difiles[i])) != NULL) {
			putdot();
			if ((tflag==0 && sfd->rdate < cutoff) ||
				    ((tflag==SCRAT && sfd->fhold==SCRAT ||
				    tflag==SHOLD && sfd->fhold==SHOLD) && 
				    sfd->rdate<cutoff)) {
				if (!Ulist)
				    addlnk(sfd, date);
				alist(difiles[i]);
				cylcnt += sfd->ncyls;
			}
		    }
		}
	    }
	}

	if (!pcylcnt)
		prtPurgFiles(lf);
	if (((lf == 1) && !Ulist) || pcylcnt)
		printf("cylinders reclamable=\t%d\n", cylcnt);
	if (Ulist)
		pUlist();
	exit(0);
}

CSNDFILE *list;

prtPurgFiles(lf) 
{
	CSNDFILE *s;

	for (s = list; s != NULL; s = s->nxtsdf) {
		if (lf)
		    printf("%-47s%3d %c %s", s->sfn, s->ncyls, 
			s->fhold, ctime(&s->rdate));
		else
		    printf("%s\n", s->sfn);
	}
}

addlnk(sfd, dfmt)
	CSNDFILE *sfd;
	int dfmt;
{
	CSNDFILE *s;

	if (list == NULL) {
		list = sfd;
		list->nxtsdf = list->lstsdf = NULL;
	} else {
		if (dfmt) {
			for (s = list; s != NULL; s = s->nxtsdf) {
				if (s->nxtsdf == NULL) {
					s->nxtsdf = sfd;
					sfd->lstsdf = s;
					break;
				}
				if (sfd->rdate < s->rdate) {
					if (s->lstsdf != NULL)
						s->lstsdf->nxtsdf = sfd;
					sfd->lstsdf = s->lstsdf;
					s->lstsdf = sfd;
					sfd->nxtsdf = s;
					if (s == list) list = sfd;
					break;
				}
			}
		} else {
			for (s = list; s != NULL; s = s->nxtsdf) {
				if (s->nxtsdf == NULL) {
					s->nxtsdf = sfd;
					sfd->lstsdf = s;
					break;
				}
			}
		}
	}
}

char *dot;

is_sfn(name)
	char *name;
{
	char *index(), *rindex();

	dot = rindex(name, '.');
	if (dot == NULL)
		return(0);
	else if (!strcmp(dot, SDFEXT)) {
		*dot = '\0';
		return(1);
	}
	return(0);
}

putdot()
{
	*dot = '.';
}
	

usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s",
"usage: purgesf [flags] directory\n",
" flags:\n",
" -S  lists scratch files that can be deleted\n",
" -H  lists hold files that can be deleted\n",
"     if neither -S nor -H is given, list both\n",
" -l  long form listing\n",
" -D  sorts by referenced date, oldest first\n",
" -tN lists files unreferenced for more than N hours\n",
" -n  only prints number of cylinders reclaimable\n",
" -U  lists users affected by purge\n",
" -N  uses \"notify\" format\n",
" -dN day N (N == # days in future) included in purge note with -N\n"
);
exit(ex);
}

char *affected[1024];
int affcnt;

alist(fname)
	char *fname;
{
	char *index(), *own, *c;
	int i, hit;

	own = index(fname+1, '/')+1;	/* isolate owner part */
	c = index(own, '/');
	if (c != NULL) 
		*c = NULL;
	for (i = hit = 0; i < affcnt; i++) {
		if (!strcmp(affected[i], own))
			hit++;
	}
	if (!hit)
		affected[affcnt++] = own;
}

pUlist()
{
	int i;

	for (i = 0; i < affcnt; i++) 
		printf("%s\n", affected[i]);
}
