/* %M%	%I%	(CARL)	%G%	%U% */
# include <carl/sndio.h>
# include <stdio.h>

extern int verbose;

/*
 * nblks - compute the number of track-sized blocks to convert
 */

long
nblks(sfd, stblk)
	CSNDFILE *sfd;
	long stblk;
{
	long sec, cnt, seccnt,
		secpcyl = sfd->blksiz / 512, 
		secptrk = sfd->bufsiz / 512;
	struct dskblk *p;

	for (seccnt = cnt = 0, p = sfd->cp; p != NULL; p = p->next) {
		for (	sec = p->base * secpcyl; 
			sec < (p->base + p->len) * secpcyl; 
			sec += secptrk, seccnt += secptrk
			) {
				
			if (seccnt+secptrk > stblk)
				cnt++;
		}
	}
	if (verbose)
		fprintf(stderr, "nblks=%d\n", cnt);
	return(cnt);
}

/*
 * mblks - calculate the starting sector numbers of each track to convert
 * and return # of track-sized blocks to be converted.
 */

long
mblks(sfd, buf, stblk)
	CSNDFILE *sfd;
	long *buf, stblk;
{
	long sec, cnt, seccnt,
		secpcyl = sfd->blksiz / 512, 
		secptrk = sfd->bufsiz / 512;
	struct dskblk *p;

	if (verbose)
		fprintf(stderr, "stblk=%d\n", stblk);
	if (verbose)
		fprintf(stderr, "secpcyl=%d\n", secpcyl);
	if (verbose)
		fprintf(stderr, "secptrk=%d\n", secptrk);
	for (seccnt = cnt = 0, p = sfd->cp; p != NULL; p = p->next) {
		if (verbose == 2)
			fprintf(stderr, 
"cylbase=%d\tcyllen=%d\tsecbase=%d\tseclen=%d\tseccnt=%d\n",
			    p->base, p->len, 
			    p->base * secpcyl,
			    p->len * secpcyl,
			    seccnt);
		for (	sec = p->base * secpcyl; 
			sec < (p->base + p->len) * secpcyl; ) {
				
			/* if (seccnt+secptrk >= stblk) */
			if (seccnt+secptrk > stblk) {
				buf[cnt] = sec;
				if (verbose == 2)
				    fprintf(stderr, 
"\tblock[%d]=%d\tat seccnt=%d\n", 
					cnt, buf[cnt], seccnt);
				cnt++;
			}
			sec += secptrk;
			seccnt += secptrk;
		}
	}
	if (verbose)
		fprintf(stderr, "total sectors=%d\n", seccnt);
	if (verbose)
		fprintf(stderr, "mblks=%d\n", cnt);
			
	return(cnt);
}

/*
 * 
 * int verbose;
 * 
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	CSNDFILE *sfp = NULL;
 * 	long max, *buf, n_used, stboff;
 * 
 * 	if (argc <= 2)
 * 		exit(1);
 * 	verbose = 1;
 * 	sfp = sopensf(argv[1], "r", NULL);
 * 	if (sfp == NULL)
 * 		exit(1);
 * 	stboff = atoi(argv[2]);
 * 	max = nblks(sfp, stboff);
 * 	fprintf(stderr, "max=%d\n", max);
 * 	if ((buf = (long *) calloc(max, sizeof(long))) == NULL) {
 * 		fprintf(stderr, "calloc failed\n");
 * 		exit(1);
 * 	}
 * 	n_used = mblks(sfp, buf, stboff);
 * 	fprintf(stderr, "n_used=%d\n", n_used);
 * 	sclosesf(sfp);
 * }
 */
