/* ediseg.c	1.2	(CARL)	8/10/84	12:09:20 */
#include "ediseg.h"

extern char *doit;	/* from interact.c */
extern char shellstr[];	/* from interact.c */

int segmod;
int segsav;
#define LISTBLEN 27
struct segment *lists[LISTBLEN]; /* lists 'A' - 'Z' + 1 */

ediseg(buf, sfd, fil)
	char *buf; struct sndesc *sfd; int fil;
{
	struct segment *rseg(), *getseg(), *cplist();
	double timefac, val;
	extern float sfexpr(); 
	int seglh = 1, segrh = 1;
	char state, action, *rindex(), *index(), *c, parseg();
	struct segment *s, *o, *seglst();

	switch (*buf) 
		{
		case QSEG:	/* s_? */
		case HSEG: 	/* s_h */
			helpediseg(); return(0);
		case PSEG:	/* sp */ 
			if (isupper(*(buf+1)))
				{
				if (pseg(lists[*(buf+1)-'A']) < 0)
					return(-1);
				}
			else
				pseg(pf[fil].sgp); 
			return(0);
		case SEGTAP:
			if (isupper(*(buf+1))) 
				BuildOn(&lists[*(buf+1)-'A'], fil);
			else
				BuildOn(&pf[fil].sgp, fil);
			return(0);
		case SETBE:	/* s_=[S] */
			c = buf+1; action = PUTBE; seglh = segsav; break;
		case SETBEG: 	/* s_bN=[S,E] , s_b=[S,E] */
		case SETEND: 	/* s_eN=[S,E] , s_e=[S,E] */
			if ((c = rindex(buf, '=')) == NULL) 
				return(-1);
			else 
				*c++ = NULL; 	/* c points to RH */
			if (*(buf+1) != NULL) 
				{
				if (*(buf+1) == LAST)
					seglh = getlast(pf[fil].sgp);
				else
					seglh = sfexpr((buf+1), 1.0);
				}
			if (seglh == 0) 
				seglh = segsav;
			action = *buf;
			break;
		case READ:	/* sr [name] */
		case RREAD:	/* sR [name] */
		case WRITE:  	/* sw [name] */
			action = *buf; buf++;  break; 
		case SEGDEL:	/* s_dN, s_d */
		case SEGMAK:	/* s_mN, s_m */
			action = *buf;
			if (*(buf+1) != NULL) 
				seglh = sfexpr(buf+1, 1.0);
			if (seglh == 0) 
				seglh = segsav;
			break;
		case '1': case '2': case '3': case '4': 
		case '5': case '6': case '7': case '8': case '9': 
			/* s_N,N,...N */
			/* unnamed segment list */
			if ((c = rindex(buf, ',')) != NULL)
				action = SEGLST; 
			else /* s_N=[S] */
			if ((c = rindex(buf, '=')) != NULL)
				{
				*c++ = NULL;	/* c points to RH */
				action = PUTBE;
				if (*buf == LAST)
					seglh = getlast(pf[fil].sgp);
				else
					seglh = sfexpr(buf, 1.0);
				}
			else /* s_N */
				{
				if (*buf != NULL) 
					{
					if (*buf == LAST)
						seglh = getlast(pf[fil].sgp);
					else
						seglh = sfexpr(buf, 1.0);
					}
				if (seglh > 0)
					action = FETCH;
				}
			break;
		case LAST:
			seglh = getlast(pf[fil].sgp);
			action = FETCH;
			break;
		default: 
			if (isupper(*buf)) 
				{ 
				if (index(buf, EQ)) 
					action = SEGLST;
				else 
					action = GETLST;
				break;
				}
			return(-1);	/* error return */
		}

	if (action==READ || action==RREAD)
		{ /* get include file for segmentation */
		register struct segment *sx, *ox;
		char *file, *defile();
		file = defile(buf, sfd);
		printf("reading %s\n", file);
		sx = rseg(file, action==READ?0:1);
		free((char *) file);
		if (sx == NULL)
			{ 
			printf("rseg: error reading file\n"); 
			return(-1); 
			}
		if (pf[fil].sgp != NULL)	/* delete old list */
			for (ox = pf[fil].sgp; ox != NULL; )
				{
				if (ox->nxtseg != NULL)
					{
					ox = ox->nxtseg;
					free((char *) ox->lstseg);
					}
				else
					{
					free((char *) ox);
					break;
					}
				}
		pf[fil].sgp = sx;
		action = FETCH;
		}
	if (pf[fil].sgp == NULL && action != SEGMAK)	
		{ 
		printf("no segments loaded!\n"); 
		return(-1); 
		}

	if (action == SEGMAK)
		{ 
		segsav = segmak(sfd, fil); 
		segmod=1; 
		return(0); 
		}
	else
	if (action == SEGLST)
		{ 
		char *listid(); 
		int listI;
		struct segment *l;
		buf = listid(buf, &listI);
		if (listI < 0) listI = LISTBLEN-1; 
		/* use end list element if list is unnamed */ 
		if (lists[listI]) 	/* delete old list */
			delseg(lists[listI]); 
		if (isupper(*buf))
			l = cplist(lists[*buf - 'A']);
		else
		if (*buf == NULL)
			l = cplist(pf[fil].sgp);
		else
			l = seglst(buf, fil);	/* construct list */
		if (l == NULL) 
			return(-1);
		lists[listI] = l;	/* save it */
		pseg(l);		/* print out its contents */
		if (doit) 		/* and maybe play it */
			{ 
			playlist(l, sfd, fil); 
			doit=0; 
			}
		return(0);
		}
	else
	if (action == GETLST)
		{ 
		int listI;
		listI = *buf - 'A';
		if (listI < 0 || listI > LISTBLEN) 
			return(-1);
		if (pf[fil].sgp != NULL) 
			delseg(pf[fil].sgp);
		pf[fil].sgp = cplist(lists[listI]);
		if (doit) 
			{ 
			playlist(lists[listI], sfd, fil); 
			doit=0; 
			}
		return(0);
		}

	if ((s = getseg(pf[fil].sgp, seglh)) == NULL) 
		return(-1);

	timefac = sfd->sr * sfd->nc;
	while (action != NULL)
		{
		switch (action) {
			case FETCH :
				pf[fil].begin = s->segbeg * timefac; 
				pf[fil].end = s->segend * timefac; 
				action = NULL;
				break;
			case PUTBE:	 /* S=_[S] */
				if (*c == NULL)	/* RH missing */
				    {	/* sN=_NULL ==> set beg and end */
				    s->segbeg = pf[fil].begin / timefac;
				    s->segend = pf[fil].end / timefac;
				    action = NULL;
				    ps(s);
				    segmod=1;
				    break;
				    }
			    else	/* S=_s[b,e]N */
			    if (*c == 's') 
				    action = parseg(c, &segrh, &val, fil);
			    else 
				    return(-1);
			    if ((o = getseg(pf[fil].sgp, segrh)) == NULL) 
				    return(-1);
			    switch (action) {
					case 'b': s->segbeg = o->segbeg; break;
					case 'e': s->segend = o->segend; break;
					case 's': s->segbeg = o->segbeg;
						  s->segend = o->segend; break;
					default: return(-1);
					}
			    action = NULL;
			    ps(s);
			    segmod=1;
			    break;
			case SETBEG: 	/* sbN=_[S,E] , sb=_[S,E] */
			case SETEND: 	/* s_eN=_[S,E] , se=_[S,E] */
			    if (*c == NULL) 
				return(-1);
			    state = parseg(c, &segrh, &val, fil);
			    if (state == 'N') 
				{
				if (action == SETBEG) 
					s->segbeg = val;
				else 
					s->segend = val;
				}
			    else
			    if (state == 'b' || state == 'e')
				{
				if ((o = getseg(pf[fil].sgp, segrh)) == NULL) 
					{ return(-1); }
				if (action == SETBEG) 
					{ 
					if (state == 'b') 
						s->segbeg = o->segbeg;
					else 
						s->segbeg = o->segend;
					}
				else 
					{ 
					if (state == 'b') 
						s->segend = o->segbeg;
					else 
						s->segend = o->segend;
					}
				}
			    else
				return(-1);
			    action = FETCH;
			    ps(s);
			    segmod=1;
			    break;
			case WRITE:
			    if (c = index(buf, EQ))
				{ 
				*c = NULL;
				if (wseg(buf, sfd, lists[*(c+1) - 'A']))
						return(-1); 
				}
			    else
				{
				if (wseg(buf, sfd, pf[fil].sgp)) 
					return(-1);
				}
			    action = NULL;
			    segmod=0;
			    break;
			case SEGDEL:
			    segdel(fil, seglh);
			    action = NULL;
			    segmod=1;
			    break;
			default: 
			    action = NULL; break;
			}
		}
	segsav = seglh;
	return(0);
	}
	    

helpediseg()
{
printf("%s%s%s%s%s%s%s%s%s%s%s%s%s",
"sr [file] 	- read segment file\n",
"sw [file][=L]	- write segment file (write segment list [L])\n",
"sp[L]		- print segments (print segment list [L]\n",
"sN		- set begin/end playing times to segment N\n",
"sb[N]=[M,S]	- set begin time of segment N to number M or segment S\n",
"		  default for N = current segment\n",
"		  default for M = current begin/end times\n",
"se[N]=[M,S]	- set end time of segment, etc. as above\n",
"s[N]=		- set begin/end times of segment to playing times\n",
"sm		- make new segment using begin/end playing times\n",
"sd[N]		- delete segment N\n",
"sN,N,...N	- make temporary segment list\n",
"sL=N,N,...N	- save segment list in buffer L\n"
);
}

playlist(list, sfd, fil)
	struct segment *list; struct sndesc *sfd; int fil;
{
	struct segment *s;
	float timefac;
	long int begin, end;

	timefac = sfd->sr * sfd->nc;
	for (s = list; s != NULL; s = s->nxtseg) {
		if (cktimes(sfd, &s->segbeg, &s->segend)) 
			continue;
		begin = s->segbeg * timefac;
		end = s->segend * timefac;
		if (shellstr[0] != '\0') {
			if (shellcmd(fil, begin, end) != 0)
				fprintf(stderr, "shellcmd failed\n");
		} else
			play(sfd, begin, end, 
				pf[fil].silence, pf[fil].repeat, 
				pf[fil].prompt, pf[fil].srover, 
				pf[fil].fltover, pf[fil].convover, 
				pf[fil].dev, pf[fil].bno, pf[fil].cnt);
	}
}

