/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <pwd.h>

/* 
 * this routine will make sure /snd is owned by disk, and will
 * create and initialize /snd/dskcyls, and /snd/dskcyls.old.
 * It expects there to be a user "disk" who is in the "sys" group,
 * and it expects there to be a unix fs mounted for the sdf files. 
 * It must be run by the superuser since it calls chown().
 * To run it:
 * % su
 * % newsfsys <csound_sdf_dir> 
 * It figures out the right devices from reading the SFSTAB file.
 * e.g., 
 * % newsfsys /snd 
 */

main(argc, argv)
	int argc; char **argv;
{
	char *malloc(), *strcpy();
	struct dskblk *makenew();
	FILE *fp, *fopen();
	struct dskblk *makenew();
	char *sdfdev, *alloc, *savalloc, *dumpinfo, *getsfile();
	struct sfstab *dirinfo(), *d;

	sdfdev = (char *) malloc(32);
	if (argc == 2) strcpy(sdfdev, argv[1]);
	else usage();
	d = dirinfo(sdfdev);
	setsfile(sdfdev);
	alloc = getsfile(ALLOCNAME);
	savalloc = getsfile(SAVALLOC);

	/* set ownership of sdf file system */
	if (chownit(sdfdev) < 0)
		exit(1);
	if (chmod(sdfdev, 0775) < 0)
		{
		perror("chmod");
		exit(1);
		}
	if (chownit(d->snddev) < 0)
		exit(1);
	/*if (chmod(d->snddev, 0771) < 0)*/
	if (chmod(d->snddev, 0664) < 0)
		{
		perror("chmod");
		exit(1);
		}
	(void) umask(~0664);

	/* make a new free list */
	if (access(alloc)) /* no initial free disk file */
		if (inifree(sdfdev, alloc, savalloc) != 0) {
			fprintf(stderr, "newsfsys: inifree failed\n");
			exit(1);
		}

	if (chownit(alloc) < 0)
		exit(1);

	/* make new dump information file, used by dumpsf, restorsf and lsf */
	dumpinfo = getsfile(SFINCREM);
	fp = fopen(dumpinfo, "w");
	if (fp == NULL)
		{
		perror("fopen");
		exit(1);
		}
	if (fclose(fp) < 0)
		{
		perror("fclose");
		exit(1);
		}
	if (chownit(dumpinfo) < 0)
		exit(1);

	exit(0);
	}

chownit(name)
	char *name;
{
	struct passwd *pw, *getpwnam();
	pw = getpwnam(SNDSUPERUSER);
	if (chown(name, pw->pw_uid, pw->pw_gid)<0)
	    {
	    perror("chown");
	    return(-1);
	    }
	return(0);
}

usage()
{
fprintf(stderr, "Usage: %s\n",
"newsfsys new_sdf_directory_name");
}
