h22331
s 00219/00000/00000
d D 1.1 84/07/25 14:27:30 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <signal.h>

/*
 * mvsf - move a sound file.  
 * Usage: mvsf source destination
 */

extern int interlock;	/* from libsf/allocsf.c */

main(argc, argv)
    	int argc; char *argv[];
{
    int err = 0, flag = 0, off = 1;
    char *getsfn();

    if (argc > 1)  
	if (strcmp(argv[1], "-f") == 0)	{ /* 'f' for "force" */
	    flag++; 
	    off++; 
	}
    if (argc < 3 || argc > 4) {
	fprintf(stderr, "Usage: mvsf [-f] source destination\n");
	exit(-1);
	}

    if (mvsf(argv[off], argv[off+1], flag) < 0) {
	fprintf(stderr, "mvsf: error moving file.\n", argv[off]);
	err++;
    }
    exit(err);
}


mvsf(src, dest, flag)
	char *src, *dest;
{
    FILE *fp, *lockfopen();
    int fclose(), delink(), ck;
    struct sndesc *sfd, *destsfd, *accesf(), *rsdf();
    struct dskblk *sfgetfl();
    char *allocat(), *sdfstr, *sdfsav, *c, *d, *getofile(); 
    struct dskblk *head;

    /* steps: */
    /* are we authorized? */
    /* is there a file there already? */
    /* if flag set, overwrite, else abort */
    /* lock file systems involved */
    /* read .sdf, change name field in it */
    /* write it to destination, creating path if necessary */
    /* change name of entries in free list */
    /* delete old .sdf file */

    /* mvsf across file systems not supported */
    sdfstr = getsfn(src, 0);
    for (c = sdfstr+1; *c != NULL; c++)
	if (*c == '/') 
		break;
    if (*c == '/') 
	*c = NULL;

    sdfsav = getofile(src, dest);

    /* compare devices */
    for (d = sdfsav+1; *d != NULL; d++)
	if (*d == '/') 
		break;
    if (*d == '/') 
	*d = NULL;
    if (strcmp(sdfstr, sdfsav)) {
	fprintf(stderr, "mvsf: use cpsf to move files across file systems\n");
	return(1);
    }

    free(sdfstr);
    free(sdfsav);
    sdfstr = getsfn(src, 0);
    sdfsav = getofile(src, dest);
    if (!strcmp(sdfstr, sdfsav)) {
	fprintf(stderr, "mvsf: source same as destination!\n");
	return(1);
    }

    /* look for dest file */
    if ((destsfd = accesf(sdfsav)) != NULL)
	if (!flag) {
	    fprintf(stderr, "mvsf: file exists: %s\n", destsfd->sfn);
	    return(1);
	} /* else ok to delete it */
    
    /* check write permission on directory */
    if (dpermis(sdfsav) != 0) {
	    fprintf(stderr, "mvsf: no directory permission for file: %s\n", 
		sdfsav);
	    return(1);
    }

    /* look for src file */
    if ((sfd = accesf(sdfstr)) == NULL) {
	fprintf(stderr, "mvsf: file not found: %s\n", src);
	return(1); /* nobody home */
    }

    /* check write permission on source */
    if (ck = ckprot(sfd->sfn, sfd->fprot, SFWRITE)) {
	if (ck == -1) {
	    fprintf(stderr, "mvsf: error checking protection\n");
	    return(-1);
	}
	else {
	    fprintf(stderr, "mvsf: no permission to move %s\n", 
		sfd->sfn);
	    return(1);
	}
    }

    /* get full pathname of dest, change sdf name of src to dest */
    sfd->sfn = sdfsav; 		/* get full dest path */
    if (ckpath(sfd->sfn) != 0) {	/* does that path exist? */
	fprintf(stderr, "mvsf: %s no such sound file path.\n", 
		getsfn(sfd->sfn, 1));
	return(1);
    }

    /* change name of entries in free list */
    interlock = 1;	/* do interlocked read/write of free list */
    if ((head = sfgetfl(sfd->sfn, 0)) == NULL)
	return(-1);
    if (chnam(head, sfd, sfd->sfn)) /* change name on free list */
	return(-1); 
    if (wlist(head, sfd->sfn, 1)) /* write it back out */
	return(-1);	

    /* write sfd to dest */
    sdfstr = allocat(sfd->sfn, SDFEXT);
    (void) umask(~(0664));
    if ((fp = lockfopen(sdfstr, "w")) == NULL) {
	fprintf(stderr, "mvsf: error opening file %s\n", sdfstr);
	return(-1);
    }
    if (wsdf(fp, sfd) != 0) {
	fprintf(stderr, "mvsf: error writing file %s\n", sdfstr);
	return(-1);
    }
    if (lockfclose(fp) < 0) {
	return(-1);
    }

    /* unlink old src sfd */
    free(sdfstr);
    sdfstr = getsfn(src, 0);
    sdfstr = allocat(sdfstr, SDFEXT);
    if (unlink(sdfstr) < 0) {
	perror("unlink");
	return(-1);
    }
    return(0);
}


/* chnam - change name of file on free list to name */
chnam(head, sfd, name)
	struct dskblk *head; struct sndesc *sfd; char *name;
{
    extern char *malloc(), *strcpy();
    struct dskblk *p, *h; 	/* points to link in arena */
    struct dskblk *q; 		/* points to link on sfd */
    if (sfd == NULL || name == NULL) return(-1);
    for (h = head, q = sfd->cp; q != NULL; q = q->next) {
	if (h->base > q->base) h = head;	/* start at top again */
        for (p = h; p->flag != EOLIST; p = p->next) {
	    if ((p->base == q->base) && (p->len == q->len)) {
		/* we have a match */
		if (p->dfn != NULL) free(p->dfn);
		p->dfn = (char *) malloc((unsigned) strlen(name)+1);
		strcpy(p->dfn, name);
		h = p;
		break;
	    }
	}
    }
    if (p->flag == EOLIST) {
	fprintf(stderr,"chnam: sfd/free-list mismatch.\n");
	return(-1); 
	/* got to end of allocation arena, indicating mismatch. */
    }
    return(0);
}

/*
 * char *
 * getofile(src, dest)
 * 	char *src, *dest;
 * {
 *     char *rindex(), *x, *y, *osfn, *getsfn(), *fsrc, *fdest, *new;
 * 
 *     fsrc = getsfn(src, 0);
 *     fdest = getsfn(dest, 0);
 *     x = rindex(fdest, '/') + 1;
 *     if (!strcmp(x, ".")) {
 * 	y = rindex(fsrc, '/') + 1;
 * 	*x = NULL;
 * 	new = (char *) malloc((unsigned) strlen(fdest) + strlen(y) + 1);
 * 	if (new  == NULL) {
 * 		fprintf(stderr, "mvsf: out of memory");
 * 		exit(1);
 * 	}
 * 	strcpy(new, fdest);
 * 	strcat(new, y);
 * 	osfn = new;
 *     }
 *     else
 * 	osfn = fdest;
 *     return(osfn);
 * }
 */
E 1
