/* wheader.c	1.1	(CARL)	7/25/84	13:45:10 */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * wheader - write a standard header on a file or pipe
 * 
 * Writes file name, sample rate, number of channels and data format
 * on a header.  Filename, srate and nchans is set from the sfd.  Format
 * is one of H_SHORTSAM or H_FLOATSAM, as defined in <carl/defaults.h>
 *
 * stdheader() comes from procom, a sub-library of libcarl.a
 */


wheader (iop, sfd, format)
FILE * iop;
CSNDFILE * sfd;
char   *format;
{
/* SDY
	extern	char *sprintf();
*/
	char    srate[16],
	        nchans[16];

	(void) sprintf (srate, "%f", sfd -> sr);
	(void) sprintf (nchans, "%d", sfd -> nc);

	return (stdheader (iop, sfd -> sfn, srate, nchans, format));
}
