/* sftype.c	1.1	(CARL)	7/25/84	13:44:34 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <carl/libsf.h>

/*
 * sftype - figure out if a name is a file, directory, or device.
 * Note: the routine does not do an access check for name == SFILE,
 * so sftype() returning SFILE is no guarantee that the file exists.
 */

sftype (name)
char   *name;
{
	extern char *index(), *strcpy(), *strcat();
	extern struct sfstab *dirinfo();
	char   *index (), *d, *getsfn ();
	char    tmp[64];
	struct defnamtab       *getdefnam ();
	int     type = SFILE;
	if (name == NULL || strlen (name) == 0)
		return (-1);
	if (*name == '/') {	/* has initial '/' ? *//* could be dev.,
				   or other's dir., or other's file */
		d = index (name + 1, '/');/* isolate the prefix */
		if (d != NULL)
			*d = NULL;
		(void) strcpy (tmp, name);/* for strcpy */
		if (d != NULL)
			*d = '/';/* put it back */
		if (dirinfo (tmp) != NULL) {/* specifies a device */
			if (d == NULL)/* and that's all */
				type = SDEV;
				/* it's a device specification */
			else	/* there is a path part also */
				type = isdir (name);
				/* see if it is dir or file */
		}
		else {		/* doesn't specify a device */
			(void) strcpy (tmp, getdefnam () -> dev);
				/* get default device */
			(void) strcat (tmp, name);/* form complete path */
			type = isdir (tmp);/* see if it is dir or file */
		}
	}
	else {			/* has no initial '/' */
		char   *tn;
		tn = getsfn (name, 0);/* make full path */
		type = isdir (tn);
		free (tn);
	}
	return (type);
}

/* isdir - look in unix fs to see if this file is a directory */

isdir (fnam)
char   *fnam;
{
	struct stat     stb;
	if (stat (fnam, &stb))
		return (-1);
	if ((stb.st_mode & S_IFMT) == S_IFDIR)
		return (SDIR);
	return (SFILE);
}

/*
 * main(argc, argv)
 * 	int argc; char **argv;
 * {
 * 	int type;
 * 	while (--argc)
 * 		{
 * 		type = sftype(*++argv);
 * 		switch(type)
 * 		    {
 * 		    case SFILE:
 * 			    printf("%s: file\n", *argv);
 * 			    break;
 * 		    case SDIR:
 * 			    printf("%s: dir\n", *argv);
 * 			    break;
 * 		    case SDEV:
 * 			    printf("%s: dev\n", *argv);
 * 			    break;
 * 		    }
 * 		}
 * 	}
 */
