/* sfiargs.c	1.2	(CARL)	12/17/84	12:32:36 */
#include <stdio.h>
#include <carl/sndio.h>
#define FALSE 0
#define TRUE 1

extern char    *arg_option;	/* in crack.c */
extern int      arg_index;	/* in crack.c */

/*
 * sfiargs - get sound file input type arguments
 * 
 * Used by sndin and friends.
 * Called with main argc and argv.  opak and name should be set to 
 * their default values
 * before being passed to sfiargs.  The routine returns the sfd of the opened
 * file (or NULL), and sets stsamp and endsamp to the values specified, or to
 * the beginning and end of the file by default.  The usage string is printed
 * when the flag -h is presented, or an unknown flag is given and ignoring is
 * true.
 */

/* declared in sopensf(), holds error status */
extern int      sferror;

struct sndesc  *sfiargs (argc, argv, opak, stsamp, endsamp, name, usage, ign)
int     argc;
char   *argv[];
char  **opak;
long   *stsamp,
       *endsamp;
char   *name,
       *usage;
int     ign;
{
	extern char *index();
	char    ch,
	        getopt (), gotflags[32], *cp = gotflags;
	char   *beginp = NULL,
	       *endp = NULL;
	float   sfexpr ();
	double  begin = 0.0,
	        end = -1.0;
	float   timefac;
	struct sndesc  *sfd,
	               *sopensf ();

	arg_index = 0;	/* reset crack() in case we're not the first here */
	while ((ch = crack (argc, argv, "ho|b|e|d|", ign)) != NULL) {
		*cp++ = ch;
		*cp = NULL;
		switch (ch) {
			case 'b': 
				beginp = arg_option;
				break;
			case 'e': 
			case 'd': 
				endp = arg_option;
				break;
			case 'o': /* opack */
				*opak = arg_option;
				break;
			case EOF: 
				/* crack returns this on unknown flag */
			case 'h': /* print help message */
				fprintf (stderr, "usage:\n%s %s\n", 
					argv[0], usage);
				return (NULL);
		}
	}

 /* were begin|end|dur flags scanned? */
	if (
	    (
		arg_index + 1 != argc
	    ) && (
		index (gotflags, 'b') == NULL 
		|| index (gotflags, 'e') == NULL
		|| index (gotflags, 'd') == NULL
	    )
	) {		/* look for begin and end times as arguments */
	/* is begin time given as argument? */
		if (arg_index < argc)/* yes */
			beginp = argv[arg_index++];
	/* is end time given as argument? */
		if (arg_index < argc)
			endp = argv[arg_index++];
	}

	if (arg_index < argc)
		name = argv[arg_index++];/* otherwise default */

 /* get the file */
	sfd = sopensf (name, "rt", (struct sndesc *) NULL);
	if (sferror != 0) {	/* set by sopensf() */
		if (sferror == SFNOFILE)
			fprintf (stderr, "%s: file %s not found\n", 
				argv[0], name);
		else
			fprintf (stderr, "%s: opensf failed\n", argv[0]);
		exit (1);
	}

	timefac = sfd -> nc * sfd -> sr;
	if (endp == NULL)	/* end not defined by user */
		end = (double) sfd -> fs;
	else
		end = sfexpr (endp, timefac);

	if (beginp == NULL)
		begin = 0;
	else
		begin = sfexpr (beginp, timefac);

	if (index (gotflags, 'd') == NULL)
		end += begin;	/* taken as duration */

 /* adjust times to the nearest sample frame boundary */
	*stsamp = begin;
	*endsamp = end;
	*stsamp = *stsamp - (*stsamp % sfd -> nc);
	*endsamp = *endsamp - (*endsamp % sfd -> nc);

	return (sfd);
}
