/* sclosesf.c	1.4	(CARL)	9/9/84	23:09:53 */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * sclosesf - close a sound file.  System version of close.  closesf() is
 * the user version.  First see if file already closed, return ok if so.
 * If file open for writing, flush its buffers (if any),  update
 * allocation file by changing all cylinders from CLAIMED to USED, update
 * rtime and atime.  If open for reading, just update rtime.  Write out
 * sound descriptor file.
 */

extern int      sfintlevel;	/* has sclosesf been called at interrupt
				   level? */
extern int      interlock;	/* from allocsf.c */

int     norefupd;		/* if !=0, don't update time
				   referenced/altered */

extern  FILE * lockfopen ();
extern  FILE * lockfp;		/* from lockfopen.c */
extern  int	sferror;	/* from sopensf */

sclosesf (sfd)
	struct sndesc  *sfd;
{
	extern long	time ();
	extern int     wsdf (), flushsf (), quitit ();
	struct dskblk  *rlist ();
	int     err = 0;
	struct dskblk  *head;
	FILE * fp;
	char   *allocat (), *getsfn (), *getsfile (), *alloc;

	if (sfd == NULL)
		return (0);	/* you can close nothing */
	if (sfd -> rw == SFCLOSED && !fa_blocks (sfd -> cp))
		return (0);	/* don't close twice, but its ok */
	if ((err = checksfd (sfd)) != 0) {
		fprintf (stderr, 
			"sclosesf: sound descriptor not ok, can't close: %o\n",
				err);
		return (-1);
	}
	if (!sfintlevel)
		ignall ();/* ignore interrupts unless already ignored */

	if (sfd -> rw & SFREAD)	/* close file open for reading */
		if (norefupd == 0)
			/* modify ref. date */
			sfd -> rdate = time ((long *) NULL);

	if (sfd -> rw & SFWRITE) {
				/* close for writing */
		flushsf (sfd);	/* force out remaining i/o */
		if (norefupd == 0)
				/* modify a/r time */
			sfd -> rdate = sfd -> adate = time ((long *) NULL);

		setsfile (sfd -> sfn);
		alloc = getsfile (ALLOCNAME);
		(void) umask (~(0664));
		interlock = 1;	/* do interlocked read/write of free list */
		if ((fp = lockfopen (alloc, "r+")) == NULL) {
				/* update allocation file */
			fprintf (stderr, "sclosesf: lockfopen failed on: %s\n",
			    alloc);
			return (-1);
		}
		lockfp = fp;	/* save fid for wlist to use */
		if ((head = rlist (fp)) == NULL) {
			fprintf (stderr, "sclosesf: error reading: %s\n", 
				alloc);
			return (-1);
		}
		if (cklist(alloc, head) != 0) {
			fprintf (stderr, 
				"sclosesf: %s: contaminated free list\n",
				alloc);
			return(-1);
		}
		if (trim (head, sfd) != 0) {
			fprintf (stderr, 
 			    "sclosesf: warning, error trimming file: %s\n", 
				sfd -> sfn);
		}
		if (markall (head, sfd, TRUE) != 0) {
			fprintf (stderr, 
			    "sclosesf: allocation check error on file: %s\n",
			    sfd -> sfn);
			return (-1);
		}
	/* write allocation arena */
		if (wlist (head, alloc, 1) != 0) {
			fprintf (stderr, "sclosesf: error updating %s\n", 
				alloc);
			return (-1);
		}
		free (alloc);
	}

 /* write sound descriptor file */
	sfd -> rw = SFCLOSED;
	if (wsdf ((FILE *) NULL, sfd)) {
		fprintf (stderr, 
			"sclosesf: error closing file: %s\n", sfd -> sfn);
		sferror = IOER;
		return (-1);
	}

	if (!sfintlevel)
		catchall (quitit);
	sync ();		/* for multiple cpu file systems */
	freesfd (sfd);		/* free the sfd structure */
	return (err);
}

fa_blocks (cp)
struct dskblk  *cp;
{
	struct dskblk  *p;

	for (p = cp; p != NULL; p = p -> next) {
		if (p -> flag == ALLOCATED || p -> flag == FREED)
			return (1);
	}
	return (0);
}
