/* linksfd.c	1.1	(CARL)	7/25/84	13:43:11 */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * Set up a doubly linked list of all open sound files, with the head
 * in rootsfd.  opensf() and sopensf() both build this list,
 * closesf() and sclosesf() manage it, deleting closed files from the
 * list.  sfallclose() uses it to march along closing all files.
 */

struct sndesc  *rootsfd;
struct sndesc  *endsfd;

linksfd (sfd)
struct sndesc  *sfd;
{
	if (sfd == NULL)
		return;
	if (rootsfd == NULL) {
		endsfd = rootsfd = sfd;
	/* make sure list doesn't point off into outer space */
		rootsfd -> lstsdf = rootsfd -> nxtsdf = NULL;
	}
	else {			/* otherwise link onto end of current list */
		endsfd -> nxtsdf = sfd;
		sfd -> lstsdf = endsfd;
		sfd -> nxtsdf = NULL;
		endsfd = sfd;
	}
}
