/* linkprop.c	1.2	(CARL)	12/18/84	10:00:47 */
#include <stdio.h>
#include <carl/sndio.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * Build linked list of properties on in-core sfd structure.
 */

linkprop (sfd, str)
	struct sndesc  *sfd;
	char   *str;
{
	extern char *strcpy(), *index();
	char *name, *value, *tmp;
	struct csnd_prop *prop,
	               *old = NULL;

	if (sfd -> csnd_p != NULL) {
		for (prop = sfd->csnd_p; prop != NULL; prop = prop->cprop_next)
			old = prop;
	}
	if ((prop = (struct csnd_prop *) malloc ((unsigned) 
	    sizeof (struct csnd_prop))) ==  NULL)
		malerr("linkprop", 1);
	tmp = index(str, ' ');
	if (tmp == NULL) {
		fprintf(stderr, "linkprop: ill-formed property: %s\n",
			str);
		return(-1);
	} else
		*tmp++ = '\0';
	if ((prop->cprop_name = malloc ((unsigned) strlen (str) + 1)) == NULL)
		malerr("linkprop", 1);
	(void) strcpy (prop->cprop_name, str);
	if ((prop->cprop_val = malloc ((unsigned) strlen (tmp) + 1)) == NULL)
		malerr("linkprop", 1);
	(void) strcpy (prop->cprop_val, tmp);
	*--tmp = ' ';
	if (old != NULL)
		old->cprop_next = prop;/* append to end of list */
	else
		sfd->csnd_p = prop;/* this is first link on list */
	prop->cprop_next = NULL;
	return (0);
}
