/* fsndo.c	1.1	(CARL)	7/25/84	13:42:29 */
#include <stdio.h>
#include <carl/sndio.h>

/*
 * Write one sample at end of file,  on file open on sfd,
 * taken to be a float.
 */


fsndo (sfd, sample)
struct sndesc  *sfd;
float   sample;
{
	extern long wrtsfb();

	if (sfd->sb == NULL && sfd->fb == NULL) {/* get buffer */
		if (getsfbuf (sfd))
			return (-1);
	}

	if (sfd->sbcnt-- < 0) {
		if ((++sfd->secptr * sfd->bufsiz) / sfd->blksiz > sfd->ncyls) {
			sfd->err = SFBNDER;
			return (-1);
		}
		if (wrtsfb (sfd, sfd->secptr) < 0)
			return (-1);
	}

	if (sfd->pm == PM16BIT)
		*(sfd->sb + sfd->sbptr++) = sample * 32767.0;
	else
		*(sfd->fb + sfd->sbptr++) = sample;

	sfd->fs++;
	sfd->bdir = SFWRITE;
	return (0);
}

/*
 * main(argc, argv)
 * 	int argc; char **argv;
 * {
 * 
 * 	float input;
 * 	struct sndesc *sfd, *sopensf(), *setsfd();
 * 
 * 	sfd = sfoargs();
 * 
 * 	sfd = sopensf(NULL, "w", sfd);
 * 
 * 	while (getfloat(&input) > 0)
 * 		if (fsndo(sfd, input) < 0)
 * 			{
 * 			fprintf(stderr, "fsndo: write error\n");
 * 			break;
 * 			}
 * 	sclosesf(sfd);
 * 	exit(0);
 * 	}
 */
