/* dfltsfd.c	1.1	(CARL)	7/25/84	13:42:07 */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * dfltsfd - take sfd and ctrl string, check ctrl string against dflts
 * for omissions, fill in omissions from args.
 * For example, see sfoargs.c
 */

struct sndesc *
dfltsfd (sfd, ctrl, dflts, args)
	struct sndesc  *sfd;
	char   *ctrl,
	       *dflts;
	char  **args;
{
	extern char *index();
	struct sndesc  *setsfd ();
	char   *c,
	        ct[3];
	int     i;

	if (dflts == NULL)
		return (NULL);
	if (sfd == NULL)
		if ((sfd = (struct sndesc *) calloc((unsigned) 
		    sizeof (struct sndesc), 1)) == NULL)
			malerr("dfltsfd", 1);
	for (c = dflts; *c != NULL; c++) {
		while (*c == '-' && *c != '\0')
			c++;
		if (*c == '\0')
			break;
		i = 0;
		if (index (ctrl, *c) == NULL) {
					/* it is missing, so supply default */
			ct[i++] = *c;	/* field to fill is in *c */
			ct[i] = '\0';	/* terminate it */
			sfd = setsfd (sfd, ct, *args);/* add it on */
			if (sfd == NULL) {
				fprintf (stderr, 
					"dfltsfd: error setting: %s to %s\n",
					ct, *args);
				goto err;
			}
		}
		args++;
	}
	return (sfd);
err: 	freesfd (sfd);
	return (NULL);
}
