/* ckblk.c	1.1	(CARL)	10/12/84	22:52:34 */
#include <stdio.h>
#include <carl/libsf.h>
#include <sys/file.h>

ckblk(bp)
	struct dskblk *bp;
{
	extern struct sndesc  * rsdf ();
	char name[BUFSIZ];
	register struct sndesc *sfd;
	register struct dskblk *p;
	register int hit;

	if (bp == NULL)
		return(-1);	/* error */
	if (bp->dfn == NULL)	/* block can't be checked */
		return(0);
	if (!strcmp(bp->dfn, "none"))
		return(0);	/* block can't be checked */

	strcpy(name, bp->dfn);
	strcat(name, SDFEXT);

	if (access(name, F_OK) != 0)
		return(0);	/* file not present */
	if ((sfd = rsdf((FILE *)NULL, name)) == NULL) {
	    fprintf(stderr, 
		"ckblk: attempt to verify that block is unused in %s failed\n",
		bp->dfn);
	    return(-1);		/* file does not exist, or has problems */
	}
	for (hit = 0, p = sfd->cp; p != NULL; p = p->next)
		if (p->base == bp->base)
			hit = -1;
	if (hit == -1) {
	    fprintf(stderr, 
		"ckblk: free list conflict detected for block base %d, file %s",
		bp->base, bp->dfn);
	}
	return(hit);
}
