h32806
s 00005/00000/00236
d D 1.2 84/12/18 09:58:33 root 2 1
c added code to handle fetching arbitrary procom(1carl) 
c properties for storage in sndesc structures.
e
s 00236/00000/00000
d D 1.1 84/07/25 13:44:06 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <ctype.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * setsfd - set a field on an sfd.  If the sfd does not exist, it is
 * created.  sfdstat marks which are set, checked by rsdf() to make sure a
 * minimum specification has been given in sdf file.
 */

extern double   ceil ();

int     sfdstat;		/* referenced in rsdf() and sfdsetok() */
#define SFDBIT(A) (1 << A)
#define SFDMASK 0777

struct sndesc  *
setsfd (sfd, ctrl, args)
	struct sndesc  *sfd;
	char   *ctrl;
	char   *args;
{
	extern char *index();
	extern char *strcpy();
	double  time,
	        cyls;
	register int    bytesps;
	extern 	 char   *malloc (), *calloc (), *realloc ();
	register char  *c,
	              **argadr;
	register long  *lp;

	if (sfd == NULL)
		if ((sfd = (struct sndesc *) calloc ((unsigned) 
		    sizeof (struct sndesc), 1)) == NULL)
			malerr("setsfd", 1);
	argadr = &args;
	c = ctrl;
	while (*c != NULL) {
		switch (*c++) {
			case FSR: /* sr - sampling rate */
				if (sscanf (*argadr, "%f", &sfd -> sr) <= 0)
					goto erexit;
				sfdstat |= SFDBIT (0);
				break;
			case FPM: /* pm - packing mode (s,f) */
				if (index (*argadr, SPMS) != NULL) {
					sfd -> pm = PM16BIT;
					sfd -> ssize = sizeof (short);
				}
				else
					if (index (*argadr, SPMF) != NULL) {
						sfd -> pm = PMFLOAT;
						sfd -> ssize = sizeof (float);
					}
					else
						goto erexit;
				sfdstat |= SFDBIT (1);
				break;
			case FRW: /* rw - read/write mode (r, w, rw) */
				sfd -> rw = 0;
				/* only exists if file is currently open 
				*/
				if (index (*argadr, SRWW) != NULL)
					sfd -> rw = SFWRITE;
				if (index (*argadr, SRWR) != NULL)
					sfd -> rw = SFREAD;
				break;
			case FNC: /* nc - # channels */
				if (sscanf (*argadr, "%d", &sfd -> nc) <= 0)
					goto erexit;
				sfdstat |= SFDBIT (2);
				break;
			case FSFOWN: /* sfown - owner */
				if (sfd -> sfown != NULL)
					free (sfd -> sfown);
				if ((sfd -> sfown = (char *) 
				    malloc ((unsigned) strlen (*argadr) + 1)) 
					== NULL)
					    malerr("setsfd", 1);
				(void) strcpy (sfd -> sfown, *argadr);
				sfdstat |= SFDBIT (3);
				break;
			case FSFN: /* sfn - file name */
				if (sfd -> sfn != NULL)
					free (sfd -> sfn);
				if ((sfd -> sfn = (char *) 
				    malloc ((unsigned) strlen (*argadr) + 1)) 
					== NULL)
					    malerr("setsfd", 1);
				(void) strcpy (sfd -> sfn, *argadr);
				sfdstat |= SFDBIT (4);
				break;
			case FRTFLAG: /* rtflag - realtime flag (r,n) */
				if (index (*argadr, SRTFLAGR) != NULL)
					sfd -> rtflag = RT;
				else
					if (index (*argadr, SRTFLAGN) != NULL)
						sfd -> rtflag = NRT;
					else
						goto erexit;
				sfdstat |= SFDBIT (5);
				break;
			case FNCYLS: /* ncyls - # cylinders */
				if (sscanf (*argadr, "%d", &sfd -> ncyls) <= 0)
					goto erexit;
				sfdstat |= SFDBIT (6);
				break;
			case FTCYLS: 
				/* ncyls - # cyls expressed as seconds */
				if (sscanf (*argadr, "%f", &time) <= 0)
					goto erexit;
				bytesps = (sfd -> pm == PM16BIT) 
					? BP16BIT : BPFLOAT;
				cyls = time * sfd -> sr * sfd -> nc * bytesps 
					/ sfd -> blksiz;
				sfd -> ncyls = (long) ceil (cyls);
			/* optional */
				break;
			case FFS: /* fs - # samples in file */
				if (sscanf (*argadr, "%d", &sfd -> fs) <= 0)
					goto erexit;
			/* this really should do some free list checking
			   first */
				sfdstat |= SFDBIT (7);
				break;
			case FREM: /* comment - Remark */
				if (linkcom (sfd, *argadr) < 0)
					goto erexit;
			/* optional */
				break;
			case FINC: /* inclsdf - Include file */
				if (linkinc (sfd, *argadr) < 0)
					goto erexit;
			/* optional */
				break;
I 2
			case FPROP: /* cprop */
				if (linkprop(sfd, *argadr) < 0)
					goto erexit;
			/* optional */
				break;
E 2
			case FPROT: /* fprot - Protection */
				if (sscanf (*argadr, "%o", &sfd -> fprot) <= 0)
					goto erexit;
				sfdstat |= SFDBIT (8);
				break;
			case FPID: /* spid - who has the file open */
				if (sscanf (*argadr, "%o", &sfd -> spid) <= 0)
					goto erexit;
			/* not there if file is closed */
				break;
			case FHOLD: /* hold - lifetime of file */
				if (index (*argadr, SCRAT) != NULL)
					sfd -> fhold = SCRAT;
				else if (index (*argadr, SHOLD) != NULL)
					sfd -> fhold = SHOLD;
				else if (index (*argadr, SKEEP) != NULL)
					sfd -> fhold = SKEEP;
				else
					goto erexit;
				break;
			case FCD: /* cdate - creation date */
				lp = &sfd -> cdate;
				goto setdate;
			case FRD: /* rdate - last referenced date */
				lp = &sfd -> rdate;
				goto setdate;
			case FAD: /* adate - last altered date */
				lp = &sfd -> adate;
				goto setdate;
			case FDD: /* dumpd - date last dumped */
				lp = &sfd -> dumpd;
				goto setdate;
			case FTK: /* tpkey - tape key */
				lp = &sfd -> tpkey;
		setdate: 
				if (sscanf (*argadr, "%ld", lp) <= 0)
					goto erexit;
				break;
			default: 
			/* ignore unknown fields */
				break;
		}
		argadr++;
	}
	return (sfd);
erexit: 
	fprintf (stderr, "setsfd failed on %s %s\n", ctrl, args);
	freesfd (sfd);
	return (NULL);
}

/*sfdsetok - returns 0 if sfd is set ok*/

sfdsetok () {
	if ((sfdstat & SFDMASK) == 0)/* nothing set at all */
		return (-1);
	if ((~sfdstat & SFDMASK) != 0) {/* say what's missing */
		int     i,
		        j;
		char   *str;
		for (i = j = 1; i < SFDMASK + 1; i = 1 << j++) {
			if ((~sfdstat & i) != 0) {
				switch (~sfdstat & i) {
					case 1: 
						str = "sampling rate";
						break;
					case 2: 
						str = "packing mode ";
						break;
					case 4: 
						str = "# channels";
						break;
					case 8: 
						str = "owner";
						break;
					case 16: 
						str = "file name";
						break;
					case 32: 
						str = "realtime flag";
						break;
					case 64: 
						str = "# cylinders";
						break;
					case 128: 
						str = "# samples";
						break;
					case 256: 
						str = "Protection";
						break;
				}
				fprintf (stderr, "setsfd: field not set: %s\n",
						str);
			}
		}
	}
	return (~sfdstat & SFDMASK);
}
E 1
