h19623
s 00039/00000/00000
d D 1.1 84/07/25 13:44:00 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>


/*
 * seeksf takes an sfd and an offset in bytes and does a deferred seek.
 * This routine is the non-realtime companion to cylseek().  Seeks are
 * always done relative to the beginning of the file.  offset=0 gets you
 * to start of file.
 */

long    seeksf (sfd, offset)
struct sndesc  *sfd;
long    offset;
{
	extern long	cyltrns();
	extern long    lseek ();
	register long   vircyl,
	                bytoff,
	                cyloff,
	                n;

	if (offset < 0 || offset > sfd -> fs * sfd -> ssize) {
		sfd -> err = SFBNDER;
		return (-1);
	}
	vircyl = offset / sfd -> blksiz; /* virtual cylinder relative to base */
	bytoff = offset % sfd -> blksiz;/* byte offset from cyl */
	cyloff = cyltrns (sfd, vircyl);/* translate to actual cylinder */
	n = lseek (sfd -> fid, cyloff * sfd -> blksiz + bytoff, 0);
				/* go to byte */
	if (n < 0) {
		perror ("seeksf:lseek");
		sfd -> err |= SFBNDER;
		return (-1);
	}
	return (offset);
}
E 1
