h45705
s 00089/00000/00000
d D 1.1 84/07/25 13:43:47 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <sys/time.h>

/* 
 * prettyprint an in-core sound file descriptor on i/o channel fp.  
 */

psdf (fp, sdp)
FILE * fp;
struct sndesc  *sdp;
{
	struct dskblk  *cp;
	struct inclist *inc;
	struct comlist *com;
	double   dur;

 /* is there any reason to go on? */
	if (sdp == NULL)
		return (-1);

	fprintf (fp, "%-32s%-14s%-11s%-10s%-10s\n",
		"name:", "owner:", "cylinders:", "realtime:", "protection:");
	fprintf (fp, "%-32s%-14s%-11D%-10c%-10o\n",
		sdp->sfn, sdp->sfown, sdp->ncyls, sdp->rtflag, sdp->fprot);

	dur = (double) sdp->fs / ((double) sdp->nc * sdp->sr);
	fprintf (fp, "%-16s%-16s%-14s%-11s%-10s%-10s\n",
	    "rate:", "hold:", "packing:", "channels:", "length:", "duration:");
	fprintf (fp, "%-16.3f%-16c%-14c%-11d%-10D%-10.3f\n",
		sdp->sr, sdp->fhold == '\0' ? SCRAT : sdp->fhold,
		sdp->pm, sdp->nc, sdp->fs, dur);

 /* write out comment(s) */
	for (com = sdp->comsdf; com != NULL; com = com->comnext)
		if (com != NULL)
			fprintf (fp, "%s\n", com->cmt);

 /* what time is it? */
	fprintf (fp, "%-26s%-26s%-26s\n", 
		"created:", "referenced:", "altered:");
	prtime (fp, sdp->cdate, ' ');
	prtime (fp, sdp->rdate, ' ');
	prtime (fp, sdp->adate, '\n');
	if (sdp->dumpd == 0)
		fprintf (fp, "not dumped.\n");
	else {
		fprintf (fp, "%-26s", "dumped:");
		prtime (fp, sdp->dumpd, ' ');
		fprintf (fp, "on dump tape %ld\n", QTAPEID (sdp->tpkey));
	}


 /* write include file strings */
	for (inc = sdp->inclsdf; inc != NULL; inc = inc->incnext)
		if (inc != NULL)
			fprintf (fp, "#include: \"%s\"\n", inc->fn);

 /* write cylinder blocks */
	fprintf (fp, "flag:\tbase:\tlen:\n");
	for (cp = sdp->cp; cp != NULL; cp = cp->next)
		fprintf (fp, "%c\t%d\t%d\n", cp->flag, cp->base, cp->len);

	return (0);
}


/* 
 * prtime - print the time in date format in x on i/o channel fp.
 * end will be stuck at end of the time string.  If it is not \n or
 * \t or something, it must be NULL.
 */

prtime (fp, x, end)
	FILE * fp;
	long    x;
	char    end;
{
	extern char *strcpy(), *index();
	char   *ctime (), *timestr, timebuf[32], *i;

	timestr = ctime (&x);
	(void) strcpy (timebuf, timestr);
	i = index (timebuf, '\n');
	if (i != NULL)
		*i = ' ';
	fprintf (fp, "%s%c", timebuf, end);
}
E 1
