h45250
s 00227/00000/00000
d D 1.1 84/07/25 13:42:10 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
# include <stdio.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/dir.h>
extern char *malloc(), *calloc(), *realloc();

# define bit(n)		(1 << (n))

# define DI_ALL		bit(0)	/* 01,  1  */
# define DI_EXACT	bit(1)	/* 02,  2  */
# define DI_PARTIAL	bit(2)	/* 04,  4  */
# define DI_ONEDIR	bit(3)	/* 010, 8  */

/*
 * diread - read unix directory.
 *
 * This reads directories searching for a key.  It has four modes:
 * 
 * DI_EXACT hits on the first instance of the exact key and returns
 * immediately.
 * 
 * DI_PARTIAL treats the key as a substring, and builds a list of
 * all files that contain that substring, via instr(name, key)
 * 
 * DI_ALL ignores the key and builds a list of all files.
 * 
 * If the mode includes DI_ONEDIR, only the first directory is searched.
 * Otherwise all directories below the one named are searched
 * recursively. DI_ONEDIR acts in compliment to the above three modes.
 * Thus DI_EXACT+DI_ONEDIR looks only in this directory for the exact
 * file; DI_PARTIAL+DI_ONEDIR looks only in this directory for any
 * substring match; DI_ALL+DI_ONEDIR produces a listing of all files in
 * this directory. DI_ALL by itself produces a listing of all files in
 * this and subtending directories.
 * 
 * diread() returns 0 on failure to match any files, 1 on success, -1
 * on error.
 *
 * diread() manages three variables:
 *	extern int difilcnt; the count of files found, 
 *	extern char **difiles; an array of pointers to the names found.
 * 		This array is built by strsav().
 *	extern int emptdir; 1 if the last directory searched was empty
 */

char  **difiles = 0;		/* base of string array that diread builds
				   */
int     difilcnt = 0;		/* count of strings in array */
int     emptdir = 0;

diread (dir, key, mode)
char   *dir,
       *key;
int     mode;
{
	extern char    *xalloc (), *strcpy(), *strcat();
	static int      level = 0;
	register struct direct *dp;
	register        DIR * dirp;
	struct stat     statb;
	char   *fullname;
	int     ret;

	fullname = NULL;

	if ((dirp = opendir (dir)) == NULL) {
		fputs ("diread: ", stderr);
		fputs ("opendir: ", stderr);
		perror (dir);
		return (-1);
	}

	emptdir = 1;

	while ((dp = readdir (dirp)) != NULL) {
	/* 
	 * skip "." and ".."
	 */
		if (strcmp (dp -> d_name, ".") == 0)
			continue;
		if (strcmp (dp -> d_name, "..") == 0)
			continue;

		if (fullname != NULL)
			free (fullname);
		fullname = xalloc(strlen(dir) + 1 + strlen(dp -> d_name) + 1);
		(void) strcpy (fullname, dir);
		(void) strcat (fullname, "/");
		(void) strcat (fullname, dp -> d_name);

		if (stat (fullname, &statb) == -1) {
			fputs ("diread: ", stderr);
			fputs ("stat: ", stderr);
			perror (fullname);
			continue;
		}

	/* 
	 * if this is a directory then search
	 * it if mode doesn't include DI_ONEDIR,
	 * in either case skip to the next entry.
	 */
		if ((statb.st_mode & S_IFMT) == S_IFDIR) {
			if ((mode & DI_ONEDIR) == 0) {
			/* 
			 * guard against "too many open files"
			 */
				if (level++ > 10) {
					closedir (dirp);
					dirp = NULL;
				}

			/* 
			 * if there was an error reading the
			 * directory then assume it's empty.
			 */
				if ((ret = diread (fullname, key, mode)) == -1)
					ret = 0;

				if (dirp == NULL) {
					if ((dirp = opendir (dir)) == NULL)
						return (-1);
				}
			}
			if ((mode & (DI_EXACT | DI_PARTIAL)) == 0)
				difilcnt = strsav (&difiles, fullname);
			continue;
		}

	/* 
	 * found a file
	 */
		emptdir = 0;

		if (mode & DI_ALL)
			difilcnt = strsav (&difiles, fullname);
		else
			if (mode & DI_EXACT) {
				if (strcmp (fullname, key) == 0)
					difilcnt = strsav (&difiles, fullname);
			}
			else
				if (mode & DI_PARTIAL) {
					if (instr (fullname, key) == 0)
						difilcnt = strsav (&difiles, 
							fullname);
				}

	}

	level--;
	closedir (dirp);
	if (fullname != NULL)
		free (fullname);

	return (difilcnt ? 1 : (ret ? 1 : 0));
}

char   *
        xalloc (n) {
	extern char    *malloc ();
	register char  *cp;

	if ((cp = malloc ((unsigned) n)) == NULL) {
		perror ("malloc");
		exit (1);
	}

	return (cp);
}

/* 
 * instr - looks for substring s2 in s1 
 */
instr (s1, s2)
char   *s1,
       *s2;
{
	extern char    *index ();
	register char  *x;

	if ((x = index (s1, *s2)) == NULL)
		return (-1);

	if (strncmp (x, s2, strlen (s2)))
		return (-1);

	return (0);
}

# ifdef notdef
/* 
 * strcpyre - copy a string, return addr. of next loc to be copied into 
 */
char   *
        strcpyre (s1, s2)
register char  *s1,
               *s2;
{
	while (*s1++ = *s2++)
		continue;

	return (--s1);
}
# endif notdef

# ifdef TEST_DIREAD
main (argc, argv)
char  **argv;
{
	register int    n;

	if (argc < 4) {
		fprintf (stderr, "usage: diread directory key mode\n");
		exit (-1);
	}

	if ((n = diread (argv[1], argv[2], atoi (argv[3]))) < 0)
		exit (1);

	for (n = 0; n < difilcnt; n++)
		printf ("%s\n", difiles[n]);

	exit (n);
}
# endif TEST_DIREAD
E 1
