h40358
s 00059/00000/00000
d D 1.1 84/07/25 13:41:51 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <pwd.h>
#include <carl/libsf.h>

/*
 * Check sound file protection.  Determine whether requestor
 * is owner, group or other with respect to the file, see if appropriate 
 * permission exists to twiddle the file.
 * 
 * If user is in the SUPERGROUP group, it is taken as super-user status.
 */

ckprot (name, prot, req)
	char   *name;
	int     prot,
		req;
{
	extern char   *getprown () , *getown ();
	char *owner;
	int     usruid,
	        usrgid,
	        ownuid,
	        owngid;
	extern struct passwd  *getpwnam (); 
	struct passwd *pw;

	if (req == 0)
		return (-1);

	if (ingroup (SUPERGROUP) == 1)
		return (0);

	pw = getpwnam (getprown ());
	usruid = pw -> pw_uid;
	usrgid = pw -> pw_gid;
	owner = getown (name);
	pw = getpwnam (owner);
	free (owner);
	ownuid = pw -> pw_uid;
	owngid = pw -> pw_gid;

	if (usruid == ownuid) {	/* user is owner */
		if ((req & SFREAD && prot & SF_IREAD) ||
				(req & SFWRITE && prot & SF_IWRITE))
			return (0);
	}
	if (usrgid == owngid) {	/* user is in group */
		if ((req & SFREAD && prot & SF_GREAD) ||
				(req & SFWRITE && prot & SF_GWRITE))
			return (0);
	}
	if (usruid != ownuid && usrgid != owngid) {
		if ((req & SFREAD && prot & SF_OREAD) ||
				(req & SFWRITE && prot & SF_OWRITE))
			return (0);
	}
	return (1);
}
E 1
