h57957
s 00091/00000/00000
d D 1.1 84/07/25 14:20:23 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/sndio.h>

extern int sferror;

float *grep;

main(argc, argv)
	char **argv;
{
	struct sndesc *opensf(), *sfd;
	float fsndi(), sample;
	register long i, j; 
	register short gcnt;
	int xit;
	int grepsf();
	char ch;

	while ((ch = crack(argc, argv, "h", 0)) != NULL) {
		switch (ch) {
			case 'h':	/* this flag takes an expression */
				usage(0);
			default:
				usage(1);
		}
	}

	if (argc < 2 || arg_index == argc)
		usage(1);

	if ((sfd = sopensf(argv[arg_index], "r", NULL)) == NULL) 
		exit(1);

	gcnt = getgrep(&grep, argc, argv, ++arg_index);

	for (i = j = 0; i < sfd->fs && j < gcnt; i++) {
		sample = fsndi(sfd, i);
		if (sferror) { 
			closesf(sfd); 
			exit(1); 
		}
		if (sample == grep[j])
			j++;
		else
			j = 0;
	}
	if (i == sfd->fs) {
		printf("pattern not found.\n");
		xit = 1;
	} else {
		printf("%d\n", i - gcnt);
		xit = 0;
	}
	closesf(sfd);
	exit(xit);
}

getgrep(f, argc, argv, index)
	float **f;
	int argc;
	char **argv;
	short index;
{
	extern float atof();
	register short i, cnt = 0;
	float sample;

	if (index < argc) {
		for (i = index; i < argc; i++)
			cnt = floatsav(f, atof(argv[i]));
	} else if (!isatty(0)) {
		while (getfloat(&sample))
			cnt = floatsav(f, sample);
	} else
		usage(1);
	return(cnt);
}

usage(x)
	int x;
{
fprintf(stderr, "%s%s%s",
"usage: grepsf filename [sample]* > starting_sample_index\n",
" or \n",
"grepsf filename < floatsams > starting_sample_index\n"
);
exit(x);
}
E 1
