/* %M%	%I%	(CARL)	%G%	%U% */
#include <carl/libsf.h>
#include <carl/dumpsf.h>

/*
 * getinc, putinc - retrieve and deposit sound file dump info.  This
 * stuff manages file SFINCREM, which ordinarily lives on the 
 * "root" sound file directories of each mounted file system, such as
 * /snd and /snd1, and contains
 * one entry for each level of dump in the format: dumplevel, dumpdate and
 * tapeid.  Tapeid is a unique positive integer applied to each dump.
 * The structure returned contains both the tapeid for the level dump specified
 * in the argument, and the maximum tapeid for all levels.  When updating
 * this database with putinc(), the tapeid for the new dump should be the
 * maximum tapeid from the last call to getinc + 1.
 * Each successive run of dumpsf updates this info, and increments
 * max tapeid by 1.  Removing file SFINCREM causes it to start all over again.
 */

/* 
 * getinc - return dump level info for key level.  Returns a structure
 * with 0's for all fields if either file is not there, 
 * or this level does not appear.  Give the structure back via free().
 */

struct incinfo *getinc(level, dev)
    int level; char *dev;
{
	extern char *calloc();
    FILE *fp, *fopen();
    struct incinfo *inc = NULL;
    char buf[BUFSIZ], *fil, *getsfile();
    int hit = 0, dumplevel, dumpdate, tpmax = 0;

    setsfile(dev);
    fil = getsfile(SFINCREM);
    if (!access(fil, 0))	/* file is there */
	{
	fp = fopen(fil, "r");
	if (fp == NULL)
	    {
	    perror(fil);
	    fprintf(stderr, "getinc: error opening %s\n", fil); 
	    exit(1);
	    }
	while (fgets(buf, BUFSIZ, fp))
	    {
	    sscanf(buf, "%d%D%d", &dumplevel, &dumpdate, &tapeid);
	    if (tapeid > tpmax) tpmax = tapeid;
	    if (level == dumplevel)  { hit++; break; }
	    }
	fclose(fp);
	}

    inc = (struct incinfo *) calloc(1, sizeof(struct incinfo));
    inc->tapeidmax = tpmax;
    if (hit)
	{
	inc->dumplevel = dumplevel;
	inc->dumpdate = dumpdate;
	inc->tapeid = tapeid;
	}

    return(inc);
    }
