/*
 *	Dan Timis - UCSB -	Thu Aug  6 12:20:36 PDT 1987
 */

#include <stdio.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/procom.h>
#include <ctype.h>
#include <rpc/rpc.h>

/*
 * 'xdrin' reads from stdin a header followed by samples. 
 * The header is similar to the 'procom header' but each string
 * is an 'xdr string' and not a NULL terminated one.
 * The samples are floats or shorts and it is the header who tells
 * us what kind of samples we have.
 * 'xdrin' builds a similar header but a 'procom' one and writes it
 * to the 'stdout'. Then the samples are converted from their external
 * reprentation to their machine dependent representation and written
 * to 'stdout'.
 * 'xdrin' could be used for converting data comming from another
 * machine into a program that expects a 'procom' header and samples.
 * Example:
 *
 *   data_from_another_machine -> | xdrin | program_expencting_samples
 */
XDR	xdrs;

main()
{
	char	*c;
	short	s;
	float	f;

	/*
	 * We get the 'xdr' header (char strings) and build a
	 * 'procom' header associated to 'stdout'
	 */
	if(!getxdrheader()){
		fprintf(stderr,"xdrin: error: no header\n");
		exit(-1);
	}
	/*
	 * Try to find if we have floats or shorts
	 */
	else if((c=getprop(stdout,H_FORMAT))==NULL){
		fprintf(stderr,
			"xdrin: error: no format in the header\n");
		exit(-1);
	}
	/*
	 * converting the floats and writing them on stdout
	 */
	else if(!strcmp(c,H_FLOATSAM)){
		while(xdr_float(&xdrs,&f))
			fputfloat(&f, stdout);
	}
	/*
	 * converting the shorts and writing them on stdout
	 */
	else if(!strcmp(c,H_SHORTSAM)){
		while(xdr_short(&xdrs,&s))
			fputshort(&s, stdout);
	}
	else {
		fprintf(stderr,
			"xdrin: error: the format in incorrect\n");
		exit(-1);
	}
	fflushfloat(stdout);
	exit(0);

}

/*
 * getxdrheader() reads char strings from the stdin and builds
 * a procom header for the stdout then puts it on stdout.
 * Return 1 on success 0 on failure.
 */

getxdrheader()
{
	struct fltbuf *fbp;
	int n, sum;
	char *name, *value;

	name = (char *) malloc(1024);
	value = (char *) malloc(1024);
	if (!name || !value)
		return(0);
	if (finitbuf(stdout))
		return(0);

	fbp = &fb[fileno(stdout)];

	xdrstdio_create(&xdrs, stdin, XDR_DECODE);

	if (!xdr_string(&xdrs, &name, 1024))
		return(0);
	if (strcmp(name, H_HEAD))
		return(0);
	if (!xdr_string(&xdrs, &value, 1024))
		return(0);
	if (putprop(stdout, name, value) != 0)
		return(0);

	while(1){
		if (!xdr_string(&xdrs, &name, 1024))
			return(0);
		if (!xdr_string(&xdrs, &value, 1024))
			return(0);
		if (putprop(stdout, name, value) != 0)
			return(0);
		if (!strcmp(name, H_TAIL)) {
			char *c;
			short ssize;

			if ((c = getprop(stdout, H_FORMAT))!=NULL){
			    if (!strcmp(c, H_FLOATSAM))
				ssize = sizeof(float);
			    else 
				ssize = sizeof(short);
			}
			bump(stdout, ssize);
			putheader(stdout);
			return(1);
		}
	}
}
