%Start A str

%{
#define MAXSTRING 300
#include "sndawk.lx.h"
#include "sndawk.h"
#undef	input


/*
 * le macro TYPESYMB associe au symbole symb (lexeme dans ce cas) le type x,
 * indique la ligne ou le lexeme se trouve et retourne un pointeur vers le
 * symbole en indiquant (ret++) qu'au coup suivant il va faloir allouer un
 * nouveau symb. VALLEX, FVAL et STRINGVAL associent a symb soit une valeur
 * pour le lexeme soit une constante soit un pointeur vers une chaine.
 */
#define TYPESYMB(x) symb->line=lineno; symb->symbtype = x; ret++; return(symb);
#define VALLEX(x) symb->lexval.ival = x;
#define FVAL(x) symb->lexval.fval = x;
#define STRINGVAL(x) symb->lexval.string = x;

int 	lineno, clen, ret; 	/* no de ligne, compteur de caracteres et ..*/
SYMB	*symb;			/* pointeur vers le symbole courant */
char	*string;
extern double atof();
SYMB *			/* la fonction yylex() est de type pointeur vers SYMB */
%}



A	[a-zA-Z_]
AN	[a-zA-Z0-9_]
D	[0-9]
E	[DEde][-+]?{D}+
WS	[ \t]

%%
	if(lineno==0){
		BEGIN A;
		lineno++;
		ret++;
	}
	if(ret){
		ALLOC(symb, SYMB)
		ret=0;
	}

<A>^\n		lineno++;
<A>^{WS}*#.*\n	lineno++;
<A>{WS}		;
<A>BEGIN	{
		TYPESYMB(LBEGIN)
		}
<A>END		{
		TYPESYMB(LEND)
		}
<A>if		{
		TYPESYMB(LIF)
		}
<A>else		{
		TYPESYMB(LELSE)
		}
<A>while	{
		TYPESYMB(LWHILE)
		}
<A>for		{
		TYPESYMB(LFOR)
		}
<A>in		{
		TYPESYMB(LFOR)
		}
<A>break	{
		TYPESYMB(LBREAK)
		}
<A>continue	{
		TYPESYMB(LCONTINUE)
		}
<A>print	{
		TYPESYMB(LPRINT)
		}
<A>printf	{
		TYPESYMB(LPRINTF)
		}
<A>printerr	{
		TYPESYMB(LPRINTERR)
		}
<A>next		{
		TYPESYMB(LNEXT)
		}
<A>exit		{
		TYPESYMB(LEXIT)
		}
<A>"{"		{
		TYPESYMB(LACCOUVR)
		}
<A>"}"		{
		TYPESYMB(LACCFERM)
		}
<A>"("		{
		TYPESYMB(LPAROUVR)
		}
<A>")"		{
		TYPESYMB(LPARFERM)
		}
<A>"["		{
		TYPESYMB(LCROOUVR)
		}
<A>"]"		{
		TYPESYMB(LCROFERM)
		}
<A>","		{
		TYPESYMB(LVIRGULE)
		}
<A>";"		{
		TYPESYMB(LPTVIRG)
		}
<A>":"		{
		TYPESYMB(LDEUXPTS)
		}
<A>"?"		{
		TYPESYMB(LPTINTER)
		}
<A>"|"		{
		TYPESYMB(LPIPE)
		}
<A>"||"		{
		VALLEX(OR)  TYPESYMB(LOGOP)
		}
<A>"&&"		{
		VALLEX(AND)  TYPESYMB(LOGOP)
		}
<A>"!"		{
		VALLEX(NOT)  TYPESYMB(LUNOP)
		}
<A>"<"		{
		VALLEX(LT)  TYPESYMB(LRELOP)
		}
<A>"<="		{
		VALLEX(LE)  TYPESYMB(LRELOP)
		}
<A>"=<"		{
		VALLEX(LE)  TYPESYMB(LRELOP)
		}
<A>"=="		{
		VALLEX(EQ)  TYPESYMB(LRELOP)
		}
<A>"!="		{
		VALLEX(NE)  TYPESYMB(LRELOP)
		}
<A>"=!"		{
		VALLEX(NE)  TYPESYMB(LRELOP)
		}
<A>">="		{
		VALLEX(GE)  TYPESYMB(LRELOP)
		}
<A>"=>"		{
		VALLEX(GE)  TYPESYMB(LRELOP)
		}
<A>">"		{
		VALLEX(GT)  TYPESYMB(LRELOP)
		}
<A>">>"		{
		TYPESYMB(LAPPEND)
		}
<A>"="		{
		VALLEX(ASSIGN)  TYPESYMB(LASGNOP)
		}
<A>"+="		{
		VALLEX(ADDEQ)  TYPESYMB(LASGNOP)
		}
<A>"-="		{
		VALLEX(SUBEQ)  TYPESYMB(LASGNOP)
		}
<A>"*="		{
		VALLEX(MULTEQ)  TYPESYMB(LASGNOP)
		}
<A>"/="		{
		VALLEX(DIVEQ)  TYPESYMB(LASGNOP)
		}
<A>"%="		{
		VALLEX(MODEQ)  TYPESYMB(LASGNOP)
		}
<A>"^"		{
		VALLEX(POW)  TYPESYMB(LARTOP3)
		}
<A>"%"		{
		VALLEX(MOD)  TYPESYMB(LARTOP3)
		}
<A>"+"		{
		VALLEX(PLUS)  TYPESYMB(LARTOP1)
		}
<A>"-"		{
		VALLEX(MINUS)  TYPESYMB(LARTOP1)
		}
<A>"*"		{
		VALLEX(MULT)  TYPESYMB(LARTOP2)
		}
<A>"/"		{
		VALLEX(DIV)  TYPESYMB(LARTOP2)
		}
<A>"++"		{
		VALLEX(INCR)  TYPESYMB(LINCDEC)
		}
<A>"--"		{
		VALLEX(DECR)  TYPESYMB(LINCDEC)
		}
<A>K		{
		VALLEX(KILO)	TYPESYMB(LPOSTOP)
		}
<A>k		{
		VALLEX(kilo)	TYPESYMB(LPOSTOP)
		}
<A>Hz		{
		VALLEX(HZ)	TYPESYMB(LPOSTOP)
		}
<A>dB		{
		VALLEX(DB)	TYPESYMB(LPOSTOP)
		}
<A>sec		{
		VALLEX(SEC)	TYPESYMB(LPOSTOP)
		}
<A>fabs		{
		VALLEX(FABS)	TYPESYMB(LFUNC)
		}
<A>floor	{
		VALLEX(FLOOR)	TYPESYMB(LFUNC)
		}
<A>ceil		{
		VALLEX(CEIL)	TYPESYMB(LFUNC)
		}
<A>exp		{
		VALLEX(EXP)	TYPESYMB(LFUNC)
		}
<A>log		{
		VALLEX(LOG)	TYPESYMB(LFUNC)
		}
<A>log10	{
		VALLEX(LOG10)	TYPESYMB(LFUNC)
		}
<A>sin		{
		VALLEX(SIN)	TYPESYMB(LFUNC)
		}
<A>cos		{
		VALLEX(COS)	TYPESYMB(LFUNC)
		}
<A>tan		{
		VALLEX(TAN)	TYPESYMB(LFUNC)
		}
<A>asin		{
		VALLEX(ASIN)	TYPESYMB(LFUNC)
		}
<A>acos		{
		VALLEX(ACOS)	TYPESYMB(LFUNC)
		}
<A>atan		{
		VALLEX(ATAN)	TYPESYMB(LFUNC)
		}
<A>(SR|ID|IC|OD|OC|NS|TM|IP|PI)	{
		string =(char *)malloc(yyleng+1*sizeof(char));
		strcpy(string,yytext);
		string[yyleng]='\000';
		STRINGVAL(string)
		TYPESYMB(LSVAR)
		}
<A>{A}{AN}*	{
		string =(char *)malloc(yyleng+1*sizeof(char));
		strcpy(string,yytext);
		string[yyleng]='\000';
		STRINGVAL(string)
		TYPESYMB(LVAR)
		}
<A>"$"		{
		TYPESYMB(LISAMPS)
		}
<A>"&"		{
		TYPESYMB(LOSAMPS)
		}
<A>{D}+"."{D}*({E})? |
<A>"."{D}+({E})? |
<A>{D}+{E}	|
<A>{D}+		{
		FVAL(atof(yytext))  TYPESYMB(LNUM)
		}

<A>\"		{
		BEGIN str; clen = 0; 
		string =(char *)malloc(MAXSTRING*sizeof(char));
		}

<A>\n		lineno++;
<A>.		{
		fprintf(stderr,"lex: line %d illegal char %c\n",
		lineno,yytext[0]);
		exit(0);
		}

<str>"\\\""	string[clen++]='"';
<str>"\\"n	string[clen++]='\n';
<str>"\\"t	string[clen++]='\t';
<str>"\\\\"	string[clen++]='\\';
<str>\n		{
		fprintf(stderr,"lex: line %d illegal car \\n in string\n",
			lineno);
		exit(0);
		}
<str>\"		{
		BEGIN A; string[clen++]='\000';
		string =(char *)realloc(string,clen*sizeof(char));
		STRINGVAL(string)
		TYPESYMB(LSTRING)
		}
<str>.		{
		string[clen++]=yytext[0];
		if(clen>=MAXSTRING-1) {
			fprintf(stderr,"lex: line %d string too long");
			exit(0);
			}
		}

%%

input()
{
	register c;
	extern char *lexprog;

	if (yysptr > yysbuf)
		c = U(*--yysptr);
	else if (yyin == NULL)
		c = *lexprog++;
	else
		c = getc(yyin);
	if (c == '\n')
		yylineno++;
	else if (c == EOF)
		c = 0;
	return(c);
}
