#include <stdio.h>
#define SYMBTYPE int
#define LEXVAL 	int
#define ACCES	int
#define YES	1
#define NO	0

/*
 * VAR c'est un element de la liste des variables. Les variable ne doivent
 * pas etre declarees. Chaque fois qu'on rencontre une, a l'analyse lexicale
 * on cherche dans la liste. Si elle n'est pas on l'ajoute. La variable peut
 * etre aussi un tableau alors dim est sa dimension.
 */
typedef	struct	variable {
	struct	variable	*next;
	float	*valeur;
	char	*nom;
	int	dim;
	} VAR;


/*
 * DELAY est un element de la ligne de retard en entree ou sortie il
 * contient des pointeurs vers l'element suivant et precedent de la ligne
 * (liste circulaire doublement chainne). Il contient IC ou OC flottants
 * et la liste va contenir ID ou OD elements.
 */
typedef struct	delay {
	struct	delay	*next, *last;
	float	*chans;
	} DELAY;
/*
 * IOSAMPS est la structure qui contient les information sur la longueur 
 * et le nombre de canaux dans la ligne de retard en entree ou en sortie,
 * ainsi qu'un pointeur vers le tableau de flottants qui la materialise
 */
typedef	struct	iosamps{
	DELAY	*elem;
	int	delay, chans;
	} IOSAMPS;


/*
 * SVAR c'est un element de la liste des variables speciales. 
 * Les variable speciales ne doivent pas etre declarees. 
 * Chaque fois qu'on rencontre une, a l'analyse lexicale
 * on cherche dans la liste. Le champs acces peut prendre les valeurs
 * YES or NO et represente l'acces en ecriture. On a toujours acces en lecture.
 */
typedef	struct	svariable {
	struct	svariable	*next;
	float	valeur;
	char	*nom;
	ACCES	acces;
	} SVAR;

typedef	struct	fil {
	FILE	*stream;
	char	*name;
	} FIL;


/*
 * VAL c'est la valeur de certains lexemes. Par exemple si le lexeme est un
 * operateur relationel le champs ival va contenir sa valeur (entier defini
 * comme macro c.a.d. <, <=, ==, etc. Le champs fval est la valeur d'une
 * constante numerique (toujours flottant). address c'est un pointeur vers
 * la structure de type VAR d'une variable et string un pointeur vers une
 * chaine de caracteres.
 * Bien sur seulement une seule valeur a la fois peut aparaitre dans VAL.
 */
typedef union	valeur{
	LEXVAL	ival;
	float	fval;
	VAR	*address;
	SVAR	*saddress;
	IOSAMPS	*ioaddress;
	char	*string;
	FIL	*file;
	} VAL;


/*
 * SYMB est un element d'une liste ou d'un arbre de symboles. Le champs
 * symbtype indique le type du symbole qui peut etre une variable ou un
 * lexeme (un terminal). frereg et frered sont des pointeurs vers d'autres
 * symboles (liste doublement chainee). fils c'est un pointeur vers la
 * liste des fils du symbole. L'arite est donnee par le nombre d'elements
 * dans cette liste. Pour les lexemes, lexval donne les informations decrites
 * plus haut pour VAL et line indique la ligne du texte source ou se trouve
 * le lexeme (pour les message d'erreur de syntaxe). Une chaine de SYMBs va
 * etre construite a l'analyse lexicale puis transforme en arbre par l'analyse
 * syntaxique puis l'arbre sera execute.
 */
typedef struct	symbol {
	struct 	symbol	*fils, *frereg, *frered;
	SYMBTYPE	symbtype;
	VAL 	lexval;
	int	line;
	} SYMB;


/*
 * ALLOC alloue l'espace memoire necessaire pour un element de type "type",
 * est fait pointe vers lui le pointeur "x" (de type poiteur vers "type").
 */
#define ALLOC(x,type) x = (type *) malloc(sizeof(type));

