include(/usr/local/include/carl/config.m4)dnl
INCLUDE =	m4INCLUDE
DESTDIR =	m4DESTDIR
CFLAGS =	-O -I${INCLUDE} -DCARL
LIBS =		m4CARLLIBS m4MATHLIB
INSTALLMAN =	rm -f m4MANDIR/${PROG}.1 ; cp ${PROG}.1 m4MANDIR

PROG= sndawk
OBJ= main.o lex.yy.o reduce.o precedence.o `eval'.o \
execute.o cherchevar.o cherchesvar.o set_spec_var.o \
setsvarval.o findadd.o findioadd.o findvaradd.o printlist.o interpol.o \
parsestr.o printflist.o

OBJ2= analyse_lex.o analyse_synt.o

TEST= synt.o lex.o pretty.o prettyprint.o

${PROG}: ${OBJ} ${OBJ2}
	cc -o ${PROG} ${OBJ} ${OBJ2} ${LIBS}

findadd.o: sndawk.lx.h sndawk.h

findioadd.o: sndawk.lx.h sndawk.h

findvaradd.o: sndawk.lx.h sndawk.h

printlist.o: sndawk.lx.h sndawk.h

printflist.o: sndawk.lx.h sndawk.h

prettyprint.o: sndawk.lx.h sndawk.h

`eval'.o: sndawk.lx.h sndawk.h

main.o: sndawk.lx.h sndawk.h

analyse_lex.o: sndawk.lx.h sndawk.h 

analyse_synt.o: sndawk.lx.h sndawk.h gram.h

execute.o: sndawk.lx.h sndawk.h

cherchevar.o: sndawk.lx.h sndawk.h

cherchesvar.o: sndawk.lx.h sndawk.h

setsvarval.o: sndawk.lx.h sndawk.h

set_spec_var.o: sndawk.lx.h sndawk.h

sndawk.lx.h: lex.h
	awk -f lex.awk lex.h >sndawk.lx.h

lex.yy.c: sndawk.lx.l sndawk.lx.h
	lex sndawk.lx.l

reduce.c: red1.pseudo.c red2.pseudo.c red3.pseudo.c red4.pseudo.c\
		reduce.awk sndawk.lx.h red5.pseudo.c
	cc -E red1.pseudo.c |awk -f reduce.awk > reduce.c;\
	cc -E red2.pseudo.c |awk -f reduce.awk >> reduce.c;\
	cc -E red3.pseudo.c |awk -f reduce.awk >> reduce.c;\
	cc -E red4.pseudo.c |awk -f reduce.awk >> reduce.c;\
	cc -E red5.pseudo.c |awk -f reduce.awk >> reduce.c;\
	cc -E redf.pseudo.c |awk -f reduce.awk >> reduce.c

analgram: gram.c gram.h sndawk.lx.h
	cc -o analgram gram.c

precedence.c: analgram sndawk.gram gram.awk
	cc -E sndawk.gram |awk -f gram.awk |analgram > precedence.c

debug: gram.c gram.h sndawk.h pretty.o
	cc -o debug -DDEBUG gram.c pretty.o

pretty.c: sndawk.lx.h pretty.awk
	awk -f pretty.awk lex.h >pretty.c

debuggram: debug sndawk.gram gram.awk
	cc -E sndawk.gram|awk -f gram.awk |debug >debuggram

test: ${OBJ} ${TEST}
	cc -o test ${TEST} ${OBJ} ${LIBS}

synt.o: analyse_synt.c sndawk.lx.h sndawk.h gram.h
	cp analyse_synt.c synt.c; cc -c -DDEBUG synt.c; rm -f synt.c

lex.o: analyse_lex.c sndawk.lx.h sndawk.h gram.h
	cp analyse_lex.c lex.c; cc -c -DDEBUG lex.c; rm -f lex.c

interpol.o: sndawk.lx.h sndawk.h

clean:
	rm -f a.out core *.o analgram debug debuggram test sndawk sndawk.lx.h \
	reduce.c pretty.c lex.yy.c precedence.c install

install:	${PROG}
		cp ${PROG} ${DESTDIR}
		${INSTALLMAN}
		date > install

ircam:		${PROG}
		cp ${PROG} ..
		date > ircam
