'''\"tbl % | eqn | pic | nroff -ms
.TL
SNDAWK - A SIGNAL PROCESSING LANGUAGE
.AU
Dan Timis
.AI
I. R. C. A. M.  31, rue St. Merri, 75004 Paris.
( mcvax ! ircam ! timis )
.AB
.PP
Signal processing and sound synthesis with the \fBUNIX\fR system often use
pipelines of programs that perform specific treatments such 
as filtering, changing
the sampling rate or the gain, etc. on binary floating point samples.
Users who want to use their own algorithms must
spend, for even a very simple treatement, time and energy to write, compile
and test a program in \fBC\fR 
or
.B FORTRAN.
.EQ
delim $$
.EN
.PP
.I sndawk
(sound \fIawk\fR)
provides a signal processing programming language
that is simple to learn
and easy to use. Inspired by the well known pattern scanning and processing
language $awk sup 1$,
it follows much of its
syntax as it includes much of the syntax of $bold C sup 2$.
.AE
.sp 3
.SH 
1. Why \fIsndawk\fB ?
.sp 1
.PP
There are essentially two kind of sounds to process: recorded sounds (often
natural sounds) or synthesized ones. Recording sounds with a computer means
converting an analog signal into a digital one and storing the samples
in a \fIsound file\fR. 
In order to play a sound, one must convert the samples of a
sound file into an analog signal. 
.PP
Programs which synthesize sounds can write samples on a pipe or store 
them in a sound file. We can think of the following scheme:
.sp 2
.PS 
	arrow right 2i "record" "command" 
SF:	box ht 1i wid 1i "sound" "file"
SSP:	box ht 1i wid 3i "sound synthesis" "program" with .ne at SF.se -(0,.5)
SP:	box ht 1i wid 2i "sound" "processing" with .w at SF.se +(.5, -.25)
	arrow
SF2:	box ht 1i wid 1i "sound" "file"
	arrow right 2i "play" "command"
	box ht 1i wid 3i "sound synthesis" "program" with .ne at SF.se -(0,.5)
	arrow from SF.e to SP.nw
	arrow from SSP.e to SP.sw
	arrow from SSP.ne -(0.5, 0) to SF.s
.PE
.sp 2
.ce
\fBfig. 1 - Sound processing chain\fR
.sp 4
.PP
At \fBI.R.C.A.M.\fR\(dg
.FS
\(dgInstitut de Recherche et Coordination Acoustique/Musique
.FE
we use a real time sound file system, $csound sup 3$,
and many programs performing
standard signal processing algorithms on binary floating point samples,
written at \fBCARL\fR\(dd.
.FS
\(ddComputer Audio Research Laboratory (UCSD)
.FE
.PP
In order to read a sound file, to apply a gain to the samples and to store
the result on another sound file, one must type the command line:
.sp 2
.ce
\fBsndin foo | gain - 6dB | sndout bar\fR
.sp 2
.PP
Programs like 
.I 
gain, filter, reverb,
.R
etc. are written in 
.B C
and are easy to use. When processing a very large amount of samples, the user
can put the command in the background and, in the meantime, do something else.
.PP
Applying a non-standard algorithm using the
.B C
language means:
.in +4
.sp 1
\(bu \fBwriting\fR the program (or modifying an already existing one),
.sp 1
\(bu \fBcompiling\fR,
.sp 1
\(bu \fBtesting\fR,
.sp 1
\(bu and finally \fBrunning\fR the program.
.sp 1
.in -4
.EQ
delim @
.EN
.PP
This could be a good solution if we would like to use the program
many times. Otherwise, an interpreted language, with the program
written in the command line (like \fIawk\fR), is a better solution. One
could apply a gain using the command:
.sp 2
.ce
\fBsndin foo | btoa | awk '{print $1 * 0.5}' | atob | sndout bar\fR
.sp 2
where \fIbtoa\fR (binary to arabic) converts binary floating point samples
into arabic numbers (as text), and \fIatob\fR converts arabic to binary. 
Of course, a pipeline
with a lot of conversions plus an interpreted program processing text, 
cannot be very fast. But to type such a command
line for a non-standard algorithm, and to wait the result, 
is very often much faster than \fBwriting\fR, \fBcompiling\fR, 
etc., a program in
.B C.
.PP
The syntax of \fIawk\fR is not well adapted to signal processing
and the use of text instead of binary floating point could not provide
satisfactory speed in execution. A command line like:
.sp 2
.ce
\fBsndin foo | sndawk 'print $ * - 6dB' | sndout bar\fR
.sp 2
is a better solution 
(of course, assuming the algorithm used is not standard and there is
no other already existing program performing it).
.sp 2
.SH
2. Usage, structure and syntax
.sp 1
.PP
\fIsndawk\fR will read binary samples when its standard input is a file or
pipe, and text when the input is a tty, the output following the same rule.
Like its model \fIawk\fR, the program can be written as an argument in the
command line or in a file:
.sp 1
.ce
\fBsndawk -f file\fR
.sp 1
.PP
Pattern matching on binary samples is much less meaningful
than on text. 
While
.I awk
searches files or standard input for patterns and performs actions upon
lines or fields of lines,
.I sndawk
simply performs specified actions upon binary floating point samples present on
standard input.
So the program structure:
.I
.sp 1
.in +15
pattern { action }
.br
pattern { action } ...
.in -15
.sp 1
.R
of
.I awk
becomes:
.sp 1
.in +15
action
.br
action ...
.sp 1
.in -15
.R
for
.I sndawk
(braces become useless).
.PP
Actions (or statements) will be applied
on each input sample (or group of input samples). The special patterns
.B BEGIN
and
.B END
will allow capture of the control before and after any
input sample is present on the standard input.
These are optional, therefore the grammar is:
.sp 1
.TS
center box;
l l l.
.sp 1
    <Program>	::=	<BEGIN section>
		<statement section> (or \fBmain loop\fR)
		<END section>
.sp 1
    <BEGIN section>	::=	\fBBEGIN\fR <statement> |
.B
		empty
.R
.sp 1
    <statement section>	::=	<statement list> |
.B
		empty
.R
.sp 1
    <END section>	::=	\fBEND\fR <statement> |
.B
		empty
.R
.sp 1
    <statement>	::=	"a \fBC\fR like statement"
.sp 1
.TE
.sp 1
.ce
\fBfig. 2 - \fIsndawk\fB grammar\fR
.sp 2
.PP
Flow-of-control statements
.B
if-else, while, for, 
.R
and statement grouping between braces, as in
\fBC\fR,
are provided. Statements are separated by semicolons, newlines or right braces.
The \fIawk\fR-like statements
.B print
and 
.B printf
will respectively put binary floating point values (when output
is not a tty) or
text on the standard output. Thus:
.sp 1
.ce
\fBprintf "%f\\n" $ + 1\fR
.in -4
.sp 1
will force text to be written on the standard output, even if it is
a file or pipe.
A file can be written or appended
using the
.B >
or the
.B >>
notation.
Other 
.B UNIX
commands or 
.B CARL
programs can be called. Thus:
.sp 1
.ce
\fBprint $ | "sndout foo"\fR
.sp 1
will write samples in the
.I csound
file
.B foo.	
.sp 2
.SH
3. Variables and expressions
.sp 1
.PP
Expressions are similar to those used in
.B C.
Arithmetic operators including 
.B %
(modulo) and
.B ^
(power), relational and logical operators together with operators ++, --,
+=, -=, etc. can be used in expression lists, multiple
assignments and can be grouped with parentheses.
Arrays and simple variables need not to be declared and are initialized to 
\fB0\fR. There is only one type:
\fB32-bit floating point\fR. Even relational expression are floating point
therefore given: 
.sp 1
.ce
\fBx = a < b;\fR
.sp 1
\fBx\fR will be
\fB1.0\fR or \fB0.0\fR according to the value of the relational expression 
(\fBtrue\fR or \fBfalse\fR).
Many functions of the mathematical library are provided:
.sp 1
.ce
\fBfabs, floor, ceil, exp, log, log10, sin, cos, tan, asin, acos, atan.\fR
.sp 1
.EQ
delim $$
.EN
.PP
Some special variables like
.B SR
(sampling rate - default 16000 sample per second),
.B NS
(number of the current sample - incremented automatically) and
.B TM
($bold NS over bold SR$  time in seconds) can be used.
.PP
Arrays are considered to be sampled functions so \fBinterpolation\fR
or \fBextrapolation\fR
are used when addressing them.
A special variable (\fBIP\fR) 
can be used to choose the degree of the polynomial interpolation (default
linear). Of course, interpolation is not used when an array element is
the left value of an assignment. While \fBa[2.25] = 0.5;\fR 
(equivalent to \fBa[2] = 0.5;\fR)
will be accepted,
\fBa[-10] = 1;\fR will produce an error.
Statements like \fBprint a[2.25];\fR or \fBprint a[-10];\fR
are correct and sensible. Thus with:
.sp 1
.in +15
.B
IP = 5;
.br
a[0] = 0;
.br
a[1] = 1;
.br
a[2] = 0.5;
.br
a[3] = 0.25;
.br
a[4] = 0.125;
.br
a[5] = 0;
.sp 1
.in -15
.R
we could think of the following envelope function:
.sp 3
.PS
X: box invis
line from X.sw +(1.000000 ,0.000000) to X.sw +(1.062500, 0.401519)
line from X.sw +(1.062500 ,0.401519) to X.sw +(1.125000, 0.747488)
line from X.sw +(1.125000 ,0.747488) to X.sw +(1.187500, 1.042772)
line from X.sw +(1.187500 ,1.042772) to X.sw +(1.250000, 1.291943)
line from X.sw +(1.250000 ,1.291943) to X.sw +(1.312500, 1.499295)
line from X.sw +(1.312500 ,1.499295) to X.sw +(1.375000, 1.668856)
line from X.sw +(1.375000 ,1.668856) to X.sw +(1.437500, 1.804392)
line from X.sw +(1.437500 ,1.804392) to X.sw +(1.500000, 1.909424)
line from X.sw +(1.500000 ,1.909424) to X.sw +(1.562500, 1.987234)
line from X.sw +(1.562500 ,1.987234) to X.sw +(1.625000, 2.040878)
line from X.sw +(1.625000 ,2.040878) to X.sw +(1.687500, 2.073192)
line from X.sw +(1.687500 ,2.073192) to X.sw +(1.750000, 2.086803)
line from X.sw +(1.750000 ,2.086803) to X.sw +(1.812500, 2.084142)
line from X.sw +(1.812500 ,2.084142) to X.sw +(1.875000, 2.067444)
line from X.sw +(1.875000 ,2.067444) to X.sw +(1.937500, 2.038769)
line from X.sw +(1.937500 ,2.038769) to X.sw +(2.000000, 2.000000)
line from X.sw +(2.000000 ,2.000000) to X.sw +(2.062500, 1.952857)
line from X.sw +(2.062500 ,1.952857) to X.sw +(2.125000, 1.898906)
line from X.sw +(2.125000 ,1.898906) to X.sw +(2.187500, 1.839563)
line from X.sw +(2.187500 ,1.839563) to X.sw +(2.250000, 1.776104)
line from X.sw +(2.250000 ,1.776104) to X.sw +(2.312500, 1.709675)
line from X.sw +(2.312500 ,1.709675) to X.sw +(2.375000, 1.641297)
line from X.sw +(2.375000 ,1.641297) to X.sw +(2.437500, 1.571874)
line from X.sw +(2.437500 ,1.571874) to X.sw +(2.500000, 1.502197)
line from X.sw +(2.500000 ,1.502197) to X.sw +(2.562500, 1.432960)
line from X.sw +(2.562500 ,1.432960) to X.sw +(2.625000, 1.364755)
line from X.sw +(2.625000 ,1.364755) to X.sw +(2.687500, 1.298087)
line from X.sw +(2.687500 ,1.298087) to X.sw +(2.750000, 1.233379)
line from X.sw +(2.750000 ,1.233379) to X.sw +(2.812500, 1.170975)
line from X.sw +(2.812500 ,1.170975) to X.sw +(2.875000, 1.111148)
line from X.sw +(2.875000 ,1.111148) to X.sw +(2.937500, 1.054107)
line from X.sw +(2.937500 ,1.054107) to X.sw +(3.000000, 1.000000)
line from X.sw +(3.000000 ,1.000000) to X.sw +(3.062500, 0.948922)
line from X.sw +(3.062500 ,0.948922) to X.sw +(3.125000, 0.900917)
line from X.sw +(3.125000 ,0.900917) to X.sw +(3.187500, 0.855989)
line from X.sw +(3.187500 ,0.855989) to X.sw +(3.250000, 0.814098)
line from X.sw +(3.250000 ,0.814098) to X.sw +(3.312500, 0.775174)
line from X.sw +(3.312500 ,0.775174) to X.sw +(3.375000, 0.739113)
line from X.sw +(3.375000 ,0.739113) to X.sw +(3.437500, 0.705788)
line from X.sw +(3.437500 ,0.705788) to X.sw +(3.500000, 0.675049)
line from X.sw +(3.500000 ,0.675049) to X.sw +(3.562500, 0.646729)
line from X.sw +(3.562500 ,0.646729) to X.sw +(3.625000, 0.620645)
line from X.sw +(3.625000 ,0.620645) to X.sw +(3.687500, 0.596607)
line from X.sw +(3.687500 ,0.596607) to X.sw +(3.750000, 0.574413)
line from X.sw +(3.750000 ,0.574413) to X.sw +(3.812500, 0.553860)
line from X.sw +(3.812500 ,0.553860) to X.sw +(3.875000, 0.534743)
line from X.sw +(3.875000 ,0.534743) to X.sw +(3.937500, 0.516856)
line from X.sw +(3.937500 ,0.516856) to X.sw +(4.000000, 0.500000)
line from X.sw +(4.000000 ,0.500000) to X.sw +(4.062500, 0.483980)
line from X.sw +(4.062500 ,0.483980) to X.sw +(4.125000, 0.468610)
line from X.sw +(4.125000 ,0.468610) to X.sw +(4.187500, 0.453715)
line from X.sw +(4.187500 ,0.453715) to X.sw +(4.250000, 0.439129)
line from X.sw +(4.250000 ,0.439129) to X.sw +(4.312500, 0.424703)
line from X.sw +(4.312500 ,0.424703) to X.sw +(4.375000, 0.410300)
line from X.sw +(4.375000 ,0.410300) to X.sw +(4.437500, 0.395801)
line from X.sw +(4.437500 ,0.395801) to X.sw +(4.500000, 0.381104)
line from X.sw +(4.500000 ,0.381104) to X.sw +(4.562500, 0.366121)
line from X.sw +(4.562500 ,0.366121) to X.sw +(4.625000, 0.350787)
line from X.sw +(4.625000 ,0.350787) to X.sw +(4.687500, 0.335053)
line from X.sw +(4.687500 ,0.335053) to X.sw +(4.750000, 0.318890)
line from X.sw +(4.750000 ,0.318890) to X.sw +(4.812500, 0.302286)
line from X.sw +(4.812500 ,0.302286) to X.sw +(4.875000, 0.285249)
line from X.sw +(4.875000 ,0.285249) to X.sw +(4.937500, 0.267806)
line from X.sw +(4.937500 ,0.267806) to X.sw +(5.000000, 0.250000)
line from X.sw +(5.000000 ,0.250000) to X.sw +(5.062500, 0.231891)
line from X.sw +(5.062500 ,0.231891) to X.sw +(5.125000, 0.213557)
line from X.sw +(5.125000 ,0.213557) to X.sw +(5.187500, 0.195087)
line from X.sw +(5.187500 ,0.195087) to X.sw +(5.250000, 0.176586)
line from X.sw +(5.250000 ,0.176586) to X.sw +(5.312500, 0.158171)
line from X.sw +(5.312500 ,0.158171) to X.sw +(5.375000, 0.139967)
line from X.sw +(5.375000 ,0.139967) to X.sw +(5.437500, 0.122109)
line from X.sw +(5.437500 ,0.122109) to X.sw +(5.500000, 0.104736)
line from X.sw +(5.500000 ,0.104736) to X.sw +(5.562500, 0.087994)
line from X.sw +(5.562500 ,0.087994) to X.sw +(5.625000, 0.072025)
line from X.sw +(5.625000 ,0.072025) to X.sw +(5.687500, 0.056975)
line from X.sw +(5.687500 ,0.056975) to X.sw +(5.750000, 0.042980)
line from X.sw +(5.750000 ,0.042980) to X.sw +(5.812500, 0.030173)
line from X.sw +(5.812500 ,0.030173) to X.sw +(5.875000, 0.018673)
line from X.sw +(5.875000 ,0.018673) to X.sw +(5.937500, 0.008587)
line from X.sw +(5.937500 ,0.008587) to X.sw +(6.000000, 0.000000)
line from X.sw +(1,0) to X.sw +(6,0)
line from X.sw +(1,0) to X.sw +(1,3)
line from X.sw +(1,0) down 0.05i
line from X.sw +(2,0) down 0.05i
line from X.sw +(3,0) down 0.05i
line from X.sw +(4,0) down 0.05i
line from X.sw +(5,0) down 0.05i
line from X.sw +(6,0) down 0.05i
"0.0" at X.sw +(1,-0.15)
"1.0" at X.sw +(2,-0.15)
"2.0" at X.sw +(3,-0.15)
"4.0" at X.sw +(5,-0.15)
"3.0" at X.sw +(4,-0.15)
"5.0" at X.sw +(6,-0.15)
line from X.sw +(1,0) left 0.05i
line from X.sw +(1,1) left 0.05i
line from X.sw +(1,2) left 0.05i
line from X.sw +(1,3) left 0.05i
"0.0" at X.sw +(0.8,0.)
"0.5" at X.sw +(0.8,1)
"1.0" at X.sw +(0.8,2)
"1.5" at X.sw +(0.8,3)
.PE
.sp 2
.ce
\fBfig. 3 - An envelope function
.sp 3
.PP
Some \fIpost-operators\fR are provided. Thus \fB-6dB\fR will be 
\fB0.501187\fR, \fB2sec\fR will mean \fB32000\fR (with \fBSR\fR = 16000) and
one could write \fBprint sin(100Hz);\fR.
.sp 3
.TS
center box;
l.
.sp 1
    $size 10{(expr) bold K~=~1024~times~(expr)}$
.sp 1
    $size 10{(expr) bold k~=~1000~times~(expr)}$
.sp 1
    $size 10{(expr) bold dB~=~10 sup {(expr) over 20}}$
.sp 1
    $size 10{(expr) bold sec~=~bold SR~times~(expr)}$
.sp 1
    $size 10{(expr) bold Hz~=~{{2 pi bold NS} over bold SR}~times~(expr)}$
.sp 1
.TE
.sp 1
.ce
\fBfig. 4 - Post-operators\fR
.bp
.SH
4. Input and output
.sp 1
.PP
Of course some would like to use a filter:
.sp 2
.PS 
	arrow right 1.5i "input" above
N:	box ht 0.5i wid 1i "x(n)"
N1:	box ht 0.5i wid 1i "x(n-1)" with .n at N.s -(0,.5)
N2:	box ht 0.5i wid 1i "x(n-2)" with .n at N1.s -(0,.5)
	arrow from N.s to N1.n
	arrow from N1.s to N2.n
	arrow from N2.s down
	"etc." at N2.s -(0,.75)
X:	circle rad .25i at N.e  +(2,0) "+"
	arrow from N.e to X -(.25,0) "a0" above
Y:	box ht 0.5i wid 1i "y(n)" with .w at X +(2,0) 
Y1:	box ht 0.5i wid 1i "y(n-1)" with .n at Y.s -(0,.5) 
Y2:	box ht 0.5i wid 1i "y(n-2)" with .n at Y1.s -(0,.5) 
	arrow from Y.s to Y1.n
	arrow from Y1.s to Y2.n
	arrow from Y2.s down
	"etc." at Y2.s -(0,.75)
	arrow from X +(.25,0) to Y.w "-b0" above
	arrow right 1.5i from Y.e "output" above
	line from N1.e right .75i "a1" above
	arrow from N1.e +(.75,0) to X chop 0 chop .25
	line from N2.e right 1.25i "a2" above
	arrow from N2.e +(1.25,0) to X chop 0 chop .25
	line from Y1.w left .75i "-b1" above
	arrow from Y1.w -(.75,0) to X chop 0 chop .25
	line from Y2.w left 1.25i "-b2" above
	arrow from Y2.w -(1.25,0) to X chop 0 chop .25
.PE
.sp 2
.ce
\fBfig. 5 - A filter\fR
.sp 1
and would want to keep some of the input and output samples. Others would like
to process multi-channel sounds (stereo, quadrophonic, etc.):
.sp 2
.PS 
	arrow right 1.5i "input" above
Cn:	box ht 1i wid 1i "IC n"
	line dashed right 0.5i
C2:	box ht 1i wid 1i "IC 2"
	line right 0.5i
C1:	box ht 1i wid 1i "IC 1"
	move right 2i
On:	box ht 1i wid 1i "OC n"
	line dashed right 0.5i
O2:	box ht 1i wid 1i "OC 2"
	line right 0.5i
O1:	box ht 1i wid 1i "OC 1"
	arrow right 1.5i "output" above
ML:	box ht 1i wid 4i with .s at C1.e +(1,1.5) "main" "loop"
	arrow up 1 from C1.n
	line up 1.25 from C2.n 
	line up 1.5 from Cn.n
	arrow from C2.n +(0,1.25) to ML.w -(0,.25)
	arrow from Cn.n +(0,1.5) to ML.w
	line <- up 1 from On.n
	line <- up 1.25 from O2.n
	line <- up 1.5 from O1.n
	line from O2.n +(0,1.25) to ML.e -(0,.25)
	line from O1.n +(0,1.5) to ML.e
.PE
.sp 2
.ce
\fBfig 6. Multi-channel processing\fR
.sp 1
and will want to read and write more than one sample
each time the \fBmain loop\fR
is executed.
.PP
Two multi-channel delay lines, one for the input the other for the output
are provided. Special variables can set, in the
.B BEGIN
section of the program, the length and number of channels for input
and output.
.B ID
is the length of the input delay (\fBOD\fR
for output)
and 
.B IC
is the number of input channels (\fBOC\fR
for output). 
.EQ
delim @
.EN
.PP
The current sample is indexed by \fB0\fR and the first channel is indexed
by \fB1\fR. The default is no delay (only current input and output samples)
and one channel. The input is denoted \fB$[\fIdelay\fB:\fIchannel\fB]\fR 
and the output \fB&[\fIdelay\fB:\fIchannel\fB]\fR. Thus
.B $[1:2]
means the previous group
of input samples, channel 2.
When the expression for
\fIdelay\fR, for \fIchannel\fR or both are missing, the respective default
value is taken. Thus \fB$\fR is equivalent to \fB$[0:1]\fR, \fB&[:2]\fR to
\fB&[0:2]\fR and \fB$[1:]\fR to \fB$[1:1]\fR.
.sp 2
.PS 
	arrow right 1.5i "input" above
C3:	box ht 1i wid 1i "$[0:n]"
	line dashed right 0.5i
C2:	box ht 1i wid 1i "$[0:2]"
	line right 0.5i
C1:	box ht 1i wid 1i "$[0:1]"
	move right 2i
O3:	box ht 1i wid 1i "&[0:n]"
	line dashed right 0.5i
O2:	box ht 1i wid 1i "&[0:2]"
	line right 0.5i
O1:	box ht 1i wid 1i "&[0:1]"
	arrow right 1.5i "output" above
ML:	box ht 1i wid 4i with .s at C1.e +(1,1.5) "main" "loop"
	arrow up 1 from C1.n
	line up 1.25 from C2.n 
	line up 1.5 from C3.n
	arrow from C2.n +(0,1.25) to ML.w -(0,.25)
	arrow from C3.n +(0,1.5) to ML.w
	line <- up 1 from O3.n
	line <- up 1.25 from O2.n
	line <- up 1.5 from O1.n
	line from O2.n +(0,1.25) to ML.e -(0,.25)
	line from O1.n +(0,1.5) to ML.e
C31:	box ht 1i wid 1i with .n at C3.s -(0,1) "$[1:n]"
	arrow from C3.s to C31.n
C21:	box ht 1i wid 1i with .n at C2.s -(0,1) "$[1:2]"
	arrow from C2.s to C21.n
C11:	box ht 1i wid 1i with .n at C1.s -(0,1) "$[1:1]"
	arrow from C1.s to C11.n
C32:	box ht 1i wid 1i with .n at C31.s -(0,1) "$[2:n]"
	arrow from C31.s to C32.n
	arrow from C32.s down 1
	"etc." at C32.s -(0,1.25)
C22:	box ht 1i wid 1i with .n at C21.s -(0,1) "$[2:2]"
	arrow from C21.s to C22.n
	arrow from C22.s down 1
	"etc." at C22.s -(0,1.25)
C12:	box ht 1i wid 1i with .n at C11.s -(0,1) "$[2:1]"
	arrow from C11.s to C12.n
	arrow from C12.s down 1
	"etc." at C12.s -(0,1.25)
O31:	box ht 1i wid 1i with .n at O3.s -(0,1) "&[1:n]"
	arrow from O3.s to O31.n
O21:	box ht 1i wid 1i with .n at O2.s -(0,1) "&[1:2]"
	arrow from O2.s to O21.n
O11:	box ht 1i wid 1i with .n at O1.s -(0,1) "&[1:1]"
	arrow from O1.s to O11.n
O32:	box ht 1i wid 1i with .n at O31.s -(0,1) "&[2:n]"
	arrow from O31.s to O32.n
	arrow from O32.s down 1
	"etc." at O32.s -(0,1.25)
O22:	box ht 1i wid 1i with .n at O21.s -(0,1) "&[2:2]"
	arrow from O21.s to O22.n
	arrow from O22.s down 1
	"etc." at O22.s -(0,1.25)
O12:	box ht 1i wid 1i with .n at O11.s -(0,1) "&[2:1]"
	arrow from O11.s to O12.n
	arrow from O12.s down 1
	"etc." at O12.s -(0,1.25)
	line from C31.e right 0.25
	line from C31.e +(.25,0) up 1.1i
	arrow from C31.e +(.25,1.1) right 3i
	line from C21.e right 0.25
	line from C21.e +(.25,0) up .8i
	arrow from C21.e +(.25,.8) right 1.5i
	arrow from C11.e right .25i
	arrow from C11.e +(.25,0) to ML.s -(.75,0)
	line from C32.e right 0.25
	line from C32.e +(.25,0) up 1.1i
	arrow from C32.e +(.25,1.1) right 3.25i
	line from C22.e right 0.25
	line from C22.e +(.25,0) up .8i
	arrow from C22.e +(.25,.8) right 1.75i
	arrow from C12.e right .5i
	arrow from C12.e +(.5,0) to ML.s -(.5,0)
	line from O21.w left 0.25
	line from O21.w -(.25,0) up .8i
	arrow from O21.w +(-.25,.8) left 1.5i
	line from O11.w left 0.25
	line from O11.w -(.25,0) up 1.1i
	arrow from O11.w +(-.25,1.1) left 3i
	arrow from O31.w left .25i
	arrow from O31.w -(.25,0) to ML.s +(.75,0)
	line from O22.w left 0.25
	line from O22.w -(.25,0) up .8i
	arrow from O22.w +(-.25,.8) left 1.75i
	line from O12.w left 0.25
	line from O12.w -(.25,0) up 1.1i
	arrow from O12.w -(.25,-1.1) left 3.25i
	arrow from O32.w left .5i
	arrow from O32.w -(.5,0) to ML.s +(.5,0)
.PE
.sp 2
.ce
\fBfig. 7 - Multi-channel input and output delay lines\fR
.sp 2
.SH
5. Design and implementation
.sp 1
.PP
The lexical analysis of the program is performed by
.I lex.
The syntactic analysis is done by an syntactic analyzer generator of the
author's design.
The program is translated into a tree which is directly interpreted.
.PP
After executing the \fBBEGIN section\fR, the special variables \fBIC\fR, 
\fBID\fR, \fBOC\fR and \fBOD\fR are consulted and the input and output
delay lines are built. A number (equal to \fBIC\fR) of samples are
read, then after one execution of the \fBstatement section\fR, if there was no
\fBprint\fR or \fBprintf\fR statement, output samples are written. Before 
repeating the cycle, delay lines, which are circular lists, are rotated.
Users must specify which value is to be assigned to the current output and
can use either the \fBprint/printf\fR statement or the default output.
.EQ
delim $$
.EN
.PP
The functions \fBgetfloat()\fR and \fBputfloat()\fR, from the $procom sup 4$ 
library are used to read and to write samples, providing full compatibility
with other \fBCARL\fR programs. 
.EQ
delim @
.EN
.PP
Tree execution is not very fast for the large amount of data required by
sound processing but the conciseness of the language and the absence of
the compiling phase make it very comfortable to use. A simple
test for speed shows that if a \fBC\fR program is faster than an
equivalent \fIsndawk\fR one, \fIawk\fR is much slower. The test was
made for the following command lines:
.B
.sp 3
.in +12
gain 2 < data1 > data2
.sp 1
sndawk '& = $ * 2' < data1 > data2
.sp 1
awk '{ print $1 * 2 }' < text1 > text2
.sp 1
.in -12
.R
data1 contained 16000 floating point samples and text1, 16000 
numbers, one number per line with no space.
.sp 2
.TS
allbox center;
l l l l.
.sp 1
	real	user	sys
.sp 1
\fBgain\fR	6.0	1.6	0.7
.sp 1
\fBsndawk\fR	18.0	11.0	1.1
.sp 1
\fBawk\fR	4:23.0	1:46.9	8.1
.sp 1
.TE
.sp 2
.ce
\fBfig. 8 Speed test\fR
.sp 2
.PP
Some simple examples of programs are given in the appendix.
.sp 3
.SH 
References
.sp 2
.IP 1.
A. V. Aho, B. W. Kernighan and P. J. Weinberger, \fIAwk - A Pattern
Scanning and Processing Language\fR, Bell Laboratories, Murray Hill, New
Jersey (1978)
.sp 1
.IP 2.
B. W. Kernighan and D. M. Ritchie, \fIThe C Programming Language\fR,
Prentice-Hall, Englewood Cliffs, New Jersey (1978)
.sp 1
.IP 3.
D. G. Loy, \fIIntroduction to the csound file system\fR, Computer Audio
Research Laboratory, UCSD, La Jolla, California (1982)
.sp 1
.IP 4.
D. G. Loy, \fIProcom - interprocess sample data communications facility
for UNIX\fR, Computer Audio
Research Laboratory, UCSD, La Jolla, California (1982)
.sp 2
.bp
.SH
Appendix
.sp 2
.ce
\fBIMPULSE RESPONSE FOR A FILTER\fR
.sp 1
.ce
impulse 100 | sndawk '\fBBEGIN OD\fR = 2; & = $ + .99 * & [ 1 : ] - .9 * & [ 2 : ]'
.sp 2
.ce
\fBSTEREO TO MONO\fR
.sp 1
.in +4
\fBBEGIN IC \fR= 2; & = .2 * $ + .8 * $ [ : 2 ]
\f
.sp 2
.ce
\fBREVERB\fR
.sp 1
\fBBEGIN\fR { \fBSR\fR = 32000; \fBID\fR = 0.5\fBsec\fR; }
.br
& = 0.5 * $ + 0.1 * $ [ 0.3\fBsec\fR: ] + 0.05 * $ [ 0.5\fBsec\fR: ] 
.sp 2
.ce
\fBFREQUENCY MODULATION\fR
.sp 1
print sin (( 200 + 10 * sin ( 5\fBHz\fR )) \fBHz\fR )
.sp 2
.ce
\fBMELODY\fR
.sp 1
\fBBEGIN\fR {
.in +4
	do = 261.62;
.br
	re = 293.66;
.br
	mi = 329.62;
.br
	dur = 0.8;
.in -4
}
.br
if ( \fBTM\fR < dur ) print sin ( do \fBHz\fR );
.br
else if ( \fBTM\fR < 2 * dur ) print sin ( re \fBHz\fR );
.br
else if ( \fBTM\fR < 3 * dur ) print sin ( mi \fBHz\fR );
.br
else print sin ( do \fBHz\fR );
.sp 2
.ce
\fBAPPLY ENVELOPE\fR
.sp 1
\fBBEGIN\fR {
.in +4
	\fBIP\fR = 5;
.br
	env [ 0 ] = 0;
.br
	env [ 1 ] = 1;
.br
	env [ 2 ] = 0.5;
.br
	env [ 3 ] = 0.25;
.br
	env [ 4 ] = 0.125;
.br
	env [ 5 ] = 0;
.br
	maxenv = 5;
.br
	totaldur = 3;
.in -4
}
.br
print $ * env [ \fBTM\fR / totaldur * maxenv ];
