#include <stdio.h>
#include "mixer.h"


#ifdef UNIXFILES
sfcls(ptr,flag)
register struct SOUND_FILE *ptr;
{
	/* Routine to close a soundfile and return memory */
	extern action_time;

	if(flag & LETGO)
		fprintf(stderr,"Closing file %s (time = %.4f)\n",ptr->fname,
		(float) (action_time / (float)
	    	(srate * (long) outchans)));
	else 
		ptr->loc = sflseek(ptr->filed,0,1) - sizeof(SFHEADER);

	if(ptr->filed >= 0) {
		if(sfclose(ptr->filed)) {
			errs.errnum = SFCLS;
			errs.str = ptr->fname;
			mixerr();
		}
		openfiles--;
	}
	ptr->filed = -2; /* Mark it continuing */
}

#else

sfcls(ptr)
register struct SOUND_FILE *ptr;
{
	/* Routine to close a soundfile and return memory */

	fprintf(stderr,"Closing file %s (time = %f)\n",ptr->fname,
	(float) (ptr->end.sft.l  / (float)
	    (srate * (long) outchans)));

	if(sfclose(ptr->filed)) {
		errs.errnum = SFCLS;
		errs.str = ptr->fname;
		mixerr();
	}
}


#endif
