# include <stdio.h>
# include "mixer.h"

qprint()
/* Procedure to print out the run queue to user area file "mix.print" */

{

	struct SOUND_FILE *ptr;
	float Osize = outchans * srate; 
	FILE *fd;

	if((fd = fopen("mix.print",mixnumber ? "a" : "w")) == NULL) {
		errs.errnum = NOPRINT;
		mixerr();
	}

	if(mixnumber)
		fprintf(fd,"mix run #%d\n",mixnumber+1);

	for(ptr = queue; ptr; ptr = ptr->right_activate) {
		fprintf(fd,"input_file %s\n",ptr->fname);
		fprintf(fd,"ampfac %f \n",ptr->ampfac);
		fprintf(fd,"start_time %f\n",(float) ptr->start.sft.l  / Osize);
		fprintf(fd,"< End time %f\n",(float) ptr->end.sft.l / Osize);
		fprintf(fd,
			"duration %f\n",(float) (ptr->end.sft.l - 
				ptr->start.sft.l) / Osize);
		if(ptr->offset.sft.l) 
			fprintf(fd,"skip %f\n",(float) ptr->offset.sft.l 
				/ srate);
		if(ptr->more != NULL) { /* If there is extra stuff */
			int i,ii;
			struct envptr *eptr;

			for( i = 0; i < outchans; i++) /* Each output channel */
			 for(ii = 0; ii < ptr->chans; ii++) if(ptr->more->send[ii][i])
			  fprintf(fd,"send %f %d %d\n",
				ptr->more->send[ii][i],ii+ 1, i+1);

			  if(ptr->more->h_envptr) 
				for(eptr = ptr->more->h_envptr; eptr; eptr = eptr->env_next)
					fprintf(fd,"env %f %f\n",eptr->env_val,
						(float) (eptr->env_start.sft.l -
						ptr->start.sft.l) / Osize);
					
		}
		if(ptr->flags & LP) 
			fprintf(fd,"loop until duration used up.\n");
		if(ptr->flags & PR) 
			fprintf(fd,"precise mode selected\n");
	}
	fprintf(fd,"< Globals\nsrate %f\nochans %d\n",srate,outchans);
	if(gskip.sft.l)
		fprintf(fd,"gskip %f\n",(float) gskip.sft.l / (float) Osize);
	if(gdur.sft.l)
		fprintf(fd,"gdur %f\n",(float) gdur.sft.l / (float) Osize);

	if(full)
		fprintf(fd,"full mix window\n");
	if(outfile[0] != '\0') 
		fprintf(fd,"output %s\n",outfile);
	fclose(fd);
}
