# define GETCORE(a) ((struct a *) calloc(1,sizeof(struct a)))

/* # units mixed at a time (short int or float) */
# define DMIXUNIT (8 * 1024) 
# define MAXCHAN 4

/* For UNIX 4.2 files */
#ifdef UNIXFILES
# include <sys/types.h>
# include <sfheader.h> 

#define savesfs()
#define unsavesfs()
#define MAXNAMLEN 1024
#define READ 0 
#define WRITE 1 0 
#define FLOAT SF_FLOAT 
#define INT SF_SHORT 
#define SFCHANS sfchans(&header)
#define SFSRATE sfsrate(&header)
#define SFCLASS sfclass(&header)
#define SFBSIZE sfbsize(&statst)
#define sfopen(x,y) open(x,y)
#define sfcreat(a,b,c,d,e,f,g) open(g,O_CREAT|O_TRUNC|O_WRONLY,0644)
#define sfclose(x) close(x)
#define sfstat(x,y,z,a) stat(x,z)
#define sffstat(x,y,z,a) fstat(x,z)
#define sfread(x,y,z) read(x,y,z)
#define sfwrite(x,y,z) write(x,y,z)
/* For CCSS files */
#else UNIXFILES
#include "soundfile.h"
#define savesfs()
#define unsavesfs()
#define SF_FLOAT FLOAT 
#define SF_SHORT INT 
#define SFCHANS sfdesc.sf_chans
#define SFSRATE sfdesc.sf_srate
#define SFCLASS sfdesc.sf_class
#define SFBSIZE sfdesc.sf_bsize
#endif UNIXFILES

char *malloc(),*calloc();

union sft {     /* Sound file times */
	off_t l;        /* in samples */
	float s;        /* in seconds */
};       

# define TIME_IN_SEC 0
# define TIME_IN_SAMP 1

struct sftime {
	union sft sft;
	short flags;
};

 
struct SOUND_FILE  {
	int     filed;
#ifdef UNIXFILES
	char    fname[MAXNAMLEN];
#else
	char    fname[15];
	char    savestatus;
#endif
	float   ampfac;
	struct  sftime start;
	struct  sftime end;
	struct  sftime offset;
	struct  SOUND_FILE
		*left_activate,
		*right_activate,
		*deactivate;
	struct  C_SPECS *more;
	short    chans;
	short    class;
	short   flags;
#ifdef UNIXFILES
	off_t	loc;
#endif
};

#ifdef UNIXFILES
/* Multiplexed flags */
#define	CANWAIT	01
#define MUSTHAVE	02
#define KEEP	04
#define LETGO	08
/* Max open files we count 0,1,2, output, and one extra for multiplexing */
#define MAXOPEN	15
#endif

/* Some mixer_flag definitions */
# define CHECK 01        /* Just check syntax */
# define PRINT 02        /* Print run queue */
# define Q_MODE 04       /* Quick mode */
# define M_MODE 010      /* Concrete mode */ 
# define DELETE 040      /* Delete a sound file from the queue */
# define CKAMP  0100     /* Do long arithmetic   */
# define STOP   0200     /* Stop mix ahead of finishing queue */

/* Individual flags */

# define LP     01      /* Loop on this file */
# define PR     02      /* Precise fade in or fade out */

struct envptr {
	struct	sftime env_start;
	long	env_end;
	long	env_dur;
	float 	env_val;
	double	env_diff;
	struct	envptr *env_next;
	struct	envptr *env_pre;
};
	
struct C_SPECS {        /* Structure for the extras */
	float   send[MAXCHAN][MAXCHAN]; /* 0-077     Cross channel stuff */
	struct  envptr *c_envptr;     /* Pointer to current env */
	struct  envptr *h_envptr;     /* Pointer to head of env */
};

/* Structure for error reporting */

struct mixerrs {

	int     errnum; /* error number - see below */
	char    *str;
	union {
		int i;
		long l;
		float f;
		char *c;
	} arg;
};

/* External globals */

	extern struct SOUND_FILE        *queue,*dealloc_queue,*last,*endptr;
	extern char outfile[];
	extern int MIXUNIT;
	extern int outfd;              /* UNIX descriptor for samples */
	extern struct mixerrs errs;    /* error structure */
	extern short mixer_flags, full;
	extern float srate;
	extern int outchans;
	extern short outflag;   /* MYMIX:  Set if ochans is specified */
	extern short rateflag;  /* M:YMIX  Set if srate is specifield */
	extern struct sftime gskip,gdur;  /* Global skip and duration */
	extern struct sftime cgskip,cgdur;  /* Command line global skip and duration */
	extern short foutput, gdurplus,cgdurplus;
#ifdef UNIXFILES
	extern short openfiles;
#endif
	extern short mixnumber;
	extern short inputfiles;

	/* Buffers */
	extern short *inint,*outint;     /* Input and output shorts */
	extern float *inflt,*outflt;     /* Ditto for floats */

# define MAX16 32767.0			/* Overflow limit */
# define END_OF_FILE 2147483648.0	/* Mark end of file */

/* Tokens */

# define KEYWORD        0
# define INPUT          1
# define START          2
# define DURATION       3
# define SKIP           4
# define OUTPUT         5
# define OCHANS         6
# define SEND           7
# define FIN            8
# define FOUT           9
# define LOOP           10
# define COMMENT        11
# define SRATE          12
# define AMPFAC         13
# define PRECISE        14
# define NPRECISE       15
# define UNIT	        16

#ifdef UNIXFILES
# define CDSF	        17
#endif

# define MIX		18
# define GLDUR		19
# define GLSKIP		20
# define FULL		21
# define ENV		22

/* Error codes for mixerr.c */

/* Fatal */
# define NOFILE         50
# define NOFDS          51
# define EMPTYFILE      52
# define BADCHAN        53                                                    
# define NOOUTPUT       54
# define NOMEM          55 
# define NOINPUT        56
# define ILLCHN         57
# define MIXEDMODE      58
# define GSKIP          59
# define SFSAVE		60
# define SFTYPE         61
# define SFREAD		62
# define SFWRITE	63
# define SFCLS          64

#ifdef UNIXFILES
# define BADHEADER	65
#endif
# define SFALIGN	66
# define SFFADE		67
# define BADENV         68

/* Warnings */
# define NOPRINT       100
# define NOOPTION      101
# define OVERFLOW      103 
# define SHORTFILE     104
# define ILLUNIT       105
# define NOTSETUP      106
# define BADSRATE      107
