#include <stdio.h>
#include "mixer.h"
#ifdef UNIXFILES
#include <sys/file.h>

/* For play drivers that can do holes in files. */
#ifdef NOGAP
#include <sys/stat.h>
#endif
#endif UNIXFILES

long    action_time;

mixctl()
{
	/* Procedure to drive the mixer program through all of the soundfiles
	   adding or deleting from the run queue as needed */

	long    current_unit = 0L;
	long     unitnums;
	register struct  SOUND_FILE *tempdq;
#ifdef UNIXFILES
	SFHEADER header;
	char *getsfname();
#endif

	action_time = 0;
	if(*outfile == NULL)
#ifndef UNIXFILES
		strcpy(outfile,"mixtest");
#else
		strcpy(outfile,getsfname("mixtest"));
#endif

	fprintf(stderr,"MIX: Output file %s [%8.2f srate and %d channel(s)].\n",
			outfile,srate,outchans);

	if(MIXUNIT != DMIXUNIT)
		fprintf(stderr,"Using buffers of %d samples\n",MIXUNIT);


	/* Get the input and output buffers - assume we need shorts in. */

	if(!inint)
		if((inint = (short *) malloc(sizeof(short) * MIXUNIT)) == NULL) 
			nomemory();
	if(foutput)   {
		if(!outflt)
			outflt = (float *) malloc(sizeof(float) * MIXUNIT);
		if(!inflt)
			if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
				nomemory();
	}
	else
		if(!outint)
			outint = (short *) malloc(sizeof(short) * MIXUNIT);

	if(!outflt && !outint) 
		nomemory();

	if(!inflt)
		for(tempdq = queue; tempdq; tempdq = tempdq->right_activate)  /* Float */
			if(tempdq->class == FLOAT) { /* Get a float buffer */
				if((inflt = (float *) malloc(sizeof(float) 
					* MIXUNIT)) == NULL) 
						nomemory();
				break;
			}

	if(mixer_flags & CKAMP) { /* CKAMP forces float buffer. */
		if(!foutput) 
			if(!outflt)
				if((outflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
					nomemory();
		if(!inflt) 
			if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
				nomemory();
	}

	fprintf(stderr,"%dK memory and %d input files.\n", sbrk(0)/1024, inputfiles);

	if((outfd = sfcreat((foutput ? FLOAT : INT),SAMPLES,PRIVATE,srate,
		outchans,"mixer",outfile)) == -1) {
		errs.errnum = NOOUTPUT;
		mixerr();
	}

#ifdef UNIXFILES
	sfmagic(&header) = SF_MAGIC;
	sfsrate(&header) = srate;
	sfchans(&header) = outchans;
	sfclass(&header) = foutput ? SF_FLOAT : SF_SHORT;
	if(wheader(outfd,&header)) {
		errs.errnum = NOOUTPUT; /* NOHEADER */
		mixerr();
	}
#endif
	


	savesfs();
	endptr=queue;
	while(queue) {
		if(queue->start.sft.l > current_unit) {  /* Found a gap */
			int distance = (queue->start.sft.l - current_unit) *
				(long) (foutput ? FLOAT : INT);
#ifndef NOGAP
			fprintf(stderr,"Skipping %.4f seconds.\n",(float) (distance /
				(srate * outchans * (foutput ? SF_FLOAT : SF_SHORT)))); 
#else
			struct stat st;
			int zero = 0;
			int reset;
			reset = lseek(outfd,0,1);
			if(fstat(outfd,&st)) {
				errs.errnum = NOFDS;
				errs.str = "output";
				mixerr();
			}
			while(distance > st.st_blksize) { 
				if(sflseek(outfd,st.st_blksize-4,1) == -1) {
					errs.errnum = SKIP;
					errs.str = "output";
					mixerr();
				}
				if(write(outfd,&zero,4) < 0) { 
					errs.errnum = SFWRITE;
					errs.str = outfile;
					mixerr();
				}
				distance -= st.st_blksize;
			}
			lseek(outfd,reset,0);
			fprintf(stderr,"\n");
#endif NOGAP
			if(sflseek(outfd,(queue->start.sft.l - current_unit) * 
				(long)  (foutput ? FLOAT : INT),1) == -1) {
					errs.errnum = SKIP;
					errs.str = "output";
					mixerr();
			}
			current_unit = queue->start.sft.l;
#ifdef NOGAP
			/* in case we over shot */
			ftruncate(outfd,lseek(outfd,0,1));
#endif
			continue;     /* Back for more */
		}

		if(endptr->filed == -1) { /* open file */
#ifdef UNIXFILES
			sfopn(endptr,CANWAIT);
#else
			sfopn();
#endif

			/* Are there multiple starts? */
			while(endptr->right_activate && 
				endptr->right_activate->start.sft.l == endptr->start.sft.l) {
					endptr = endptr->right_activate;
#ifdef UNIXFILES
					sfopn(endptr,CANWAIT);        /* open another */
#else
					sfopn();        /* open another */
#endif
			}
		}
		/* Which is first? Start a file or finish one? 
			    What if they finish at the same time?   */

		if(endptr->right_activate &&
		    endptr->right_activate->start.sft.l < dealloc_queue->end.sft.l) 
			action_time = endptr->right_activate->start.sft.l;
		else {
			action_time = dealloc_queue->end.sft.l;
			mixer_flags |= DELETE;
		}

		if(gdur.sft.l && gdur.sft.l < action_time) {
			action_time = gdur.sft.l;
			mixer_flags |= STOP;
		}

		/* Ok, ready to mix */
		/* Unitnums is in samples */

		unitnums = action_time - current_unit;
		if(unitnums) { /* As long as we didn't also need to add a file */
			setmode();          /* Set up if concrete or quick mode */
			if((mixer_flags & M_MODE) || (mixer_flags & CKAMP)) 
				cmixem(endptr,unitnums,current_unit);
			else 
				qmixem(endptr,unitnums,current_unit);
		}

		/* Now we have run into the next action time */

		if(mixer_flags & STOP) { /* Close files and free memory. */
			struct SOUND_FILE *ptr;
			for(ptr = queue; ptr != endptr->right_activate;
				ptr = ptr->right_activate) 
#ifdef UNIXFILES
					sfcls(ptr,LETGO);
#else UNIXFILES
					sfcls(ptr);
#endif UNIXFILES
			for(ptr = queue; ptr; ptr = ptr->right_activate) 
				if(ptr->more)
					free((char *) ptr->more);
				free((char *) ptr);
			break;
		}
			
		if(mixer_flags & DELETE) /* Remove some files */
			while(dealloc_queue->end.sft.l == action_time) { 
#ifdef UNIXFILES
				sfcls(dealloc_queue,LETGO); /* Close soundfile */
#else
				sfcls(dealloc_queue); /* Close soundfile */
#endif UNIXFILES
				if(dealloc_queue == queue) { /* head node */
					if(endptr == queue) 
						endptr = queue->right_activate; /* one file */
					queue = queue->right_activate;
				}
				else { /* node in between */
					dealloc_queue->left_activate->right_activate = 
						dealloc_queue->right_activate;
					if(dealloc_queue->right_activate)
						dealloc_queue->right_activate->left_activate = 
							dealloc_queue->left_activate;
				}

				tempdq = dealloc_queue;
				dealloc_queue = dealloc_queue->deactivate;
				if(tempdq->more) 
					free((char *) tempdq->more);
				free((char *) tempdq);
				mixer_flags &= ~DELETE;
			}

		/* Not a delete */

		else 
			if(endptr->right_activate) 
				endptr = endptr->right_activate;
		current_unit = action_time;        /* Reset */
	} /* While end */

	if(gdur.sft.l > action_time) { /* Silence at end */
		int zero = 0;
		int distance = (gdur.sft.l - current_unit) *
			(long) (foutput ? FLOAT : INT);

		sflseek(outfd,distance  - sizeof(int),1);
		fprintf(stderr,"Skipping %.4f seconds at end.\n",
			(float) (distance / (srate * outchans * 
				(foutput ? SF_FLOAT : SF_SHORT)))); 
		if(sfwrite(outfd,&zero,sizeof(int)) < sizeof(int)) {
			errs.errnum = SFWRITE;
			mixerr();
		}
	}
	sfclose(outfd);
}
