# include <stdio.h>
# include "mixer.h"

fmix(mul,inc,ibuf,obuf,ichans,count)
	double mul, inc;
	register float *ibuf, *obuf;
	register int ichans;
	int count;
{

	register float *endin = ibuf + count;
	register ochans = outchans;

	if(inc)  /* Envelope */
		while(ibuf < endin) {
			*obuf += *ibuf * mul;
			mul += inc;
			ibuf += ichans;
			obuf += ochans;
		}
	else
		if(ichans > 0) /* Might be cross channel */
			if(mul != 1)
				while(ibuf < endin) {
					*obuf += *ibuf * mul;
					ibuf += ichans;
					obuf += ochans;
				}
			else /* No ampfac */
				while(ibuf < endin) {
					*obuf += *ibuf;
					ibuf += ichans;
					obuf += ochans;
				}
		else /* No chance of cross channel */
			if(mul != 1)
				while(ibuf < endin) 
					*obuf++ += *ibuf++ * mul;
			else
				while(ibuf < endin) 
					*obuf++ += *ibuf++;
}
