h64524
s 00002/00001/00062
d D 1.14 86/02/10 18:12:41 robert 14 13
c Envelope times were not relative to start of file.
e
s 00007/00007/00056
d D 1.13 85/10/21 17:15:12 robert 13 12
c Working version with envelopes.
e
s 00019/00013/00044
d D 1.12 85/09/02 20:28:32 robert 12 11
c Added 'full' keyword.
e
s 00005/00003/00052
d D 1.11 85/08/29 13:22:54 robert 11 10
c Print out gskip and gdur only if they are non-zero.
e
s 00011/00011/00044
d D 1.10 85/08/27 21:39:27 robert 10 9
c Version with input for samples.
e
s 00003/00000/00052
d D 1.9 85/08/27 19:04:32 robert 9 8
c Just before change sample input.
e
s 00002/00002/00050
d D 1.8 85/08/27 16:30:44 robert 8 7
c Bad printout for value of fout.
e
s 00001/00001/00051
d D 1.7 85/07/23 18:33:06 robert 7 6
c Corrected output of 'skip'
e
s 00004/00001/00048
d D 1.6 85/07/13 10:44:35 robert 6 5
c Added the -S flag and setup qprint for more than one mix.
e
s 00018/00009/00031
d D 1.5 85/06/25 20:29:07 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00001/00001/00039
d D 1.4 85/06/25 12:02:57 robert 4 3
c 4.2 working version for UNIX files.
e
s 00000/00000/00040
d D 1.3 84/05/16 15:09:27 robert 3 2
c Working (I think) version for exact mixing.
e
s 00001/00001/00039
d D 1.2 84/05/11 16:54:20 robert 2 1
c First version of exact sample mixing. Robert
e
s 00040/00000/00000
d D 1.1 82/12/08 08:37:52 robert 1 0
c date and time created 82/12/08 08:37:52 by robert
e
u
U
t
T
I 1
# include <stdio.h>
# include "mixer.h"

qprint()
/* Procedure to print out the run queue to user area file "mix.print" */

{

	struct SOUND_FILE *ptr;
D 2
	float Osize = outchans * srate / (float) MIXUNIT;
E 2
I 2
	float Osize = outchans * srate; 
E 2
	FILE *fd;

D 6
	if((fd = fopen("mix.print","w")) == NULL) {
E 6
I 6
	if((fd = fopen("mix.print",mixnumber ? "a" : "w")) == NULL) {
E 6
		errs.errnum = NOPRINT;
		mixerr();
	}
I 6

	if(mixnumber)
		fprintf(fd,"mix run #%d\n",mixnumber+1);
E 6

	for(ptr = queue; ptr; ptr = ptr->right_activate) {
		fprintf(fd,"input_file %s\n",ptr->fname);
		fprintf(fd,"ampfac %f \n",ptr->ampfac);
D 10
		fprintf(fd,"start_time %f\n",(float) ptr->start.l  / Osize);
D 4
		fprintf(fd,"COMMENT End time %f\n",(float) ptr->end.l / Osize);
E 4
I 4
		fprintf(fd,"< End time %f\n",(float) ptr->end.l / Osize);
E 10
I 10
		fprintf(fd,"start_time %f\n",(float) ptr->start.sft.l  / Osize);
		fprintf(fd,"< End time %f\n",(float) ptr->end.sft.l / Osize);
E 10
E 4
D 5
		fprintf(fd,"duration %f\n",(float) (ptr->end.l - ptr->start.l) / Osize);
		if(ptr->offset.l) fprintf(fd,"skip %f\n",(float) ptr->offset.l / Osize);
E 5
I 5
		fprintf(fd,
D 10
			"duration %f\n",(float) (ptr->end.l - ptr->start.l) / Osize);
E 10
I 10
D 12
			"duration %f\n",(float) (ptr->end.sft.l - ptr->start.sft.l) / Osize);
E 10
		if(ptr->offset.l) 
D 7
			fprintf(fd,"skip %f\n",(float) ptr->offset.l / Osize);
E 7
I 7
			fprintf(fd,"skip %f\n",(float) ptr->offset.l / (ptr->class * srate));
E 12
I 12
			"duration %f\n",(float) (ptr->end.sft.l - 
				ptr->start.sft.l) / Osize);
		if(ptr->offset.sft.l) 
			fprintf(fd,"skip %f\n",(float) ptr->offset.sft.l 
				/ srate);
E 12
E 7
E 5
		if(ptr->more != NULL) { /* If there is extra stuff */
			int i,ii;
I 13
			struct envptr *eptr;
E 13

			for( i = 0; i < outchans; i++) /* Each output channel */
D 5
				for(ii = 0; ii < ptr->chans; ii++) if(ptr->more->send[ii][i])
					fprintf(fd,"send %f %d %d\n",ptr->more->send[ii][i],ii+ 1, i+1);
			if(ptr->more->fn.l) fprintf(fd,"fin %f\n",(float) (ptr->more->fn.l - ptr->start.l) / Osize);
			if(ptr->more->ft.l) fprintf(fd,"fout %f\n",(float) (ptr->more->ft.l - ptr->start.l) / Osize);
E 5
I 5
			 for(ii = 0; ii < ptr->chans; ii++) if(ptr->more->send[ii][i])
D 12
			  fprintf(fd,"send %f %d %d\n",ptr->more->send[ii][i],ii+ 1, i+1);
E 12
I 12
			  fprintf(fd,"send %f %d %d\n",
				ptr->more->send[ii][i],ii+ 1, i+1);
E 12
D 10
			  if(ptr->more->fn.l) 
			   fprintf(fd,"fin %f\n",(float) (ptr->more->fn.l 
				- ptr->start.l) / Osize);
			  if(ptr->more->ft.l) 
D 8
			   fprintf(fd,"fout %f\n",(float) (ptr->more->ft.l 
				- ptr->start.l) / Osize);
E 8
I 8
			   fprintf(fd,"fout %f\n",(float) (ptr->end.l 
				- ptr->more->ft.l) / Osize);
E 10
I 10
D 13
			  if(ptr->more->fn.sft.l) 
D 12
			   fprintf(fd,"fin %f\n",(float) (ptr->more->fn.sft.l 
				- ptr->start.sft.l) / Osize);
E 12
I 12
			   fprintf(fd,"fin %f (starts at %f)\n",
				(float) ptr->more->fndur / Osize, 
					(ptr->more->fn.sft.l - ptr->more->fndur) / Osize);
E 12
			  if(ptr->more->ft.sft.l) 
D 12
			   fprintf(fd,"fout %f\n",(float) (ptr->end.sft.l 
				- ptr->more->ft.sft.l) / Osize);
E 12
I 12
			   fprintf(fd,"fout %f (starts at %f)\n",(float) (ptr->more->ftdur) / Osize,
				ptr->more->ft.sft.l/Osize);
E 13
I 13

			  if(ptr->more->h_envptr) 
				for(eptr = ptr->more->h_envptr; eptr; eptr = eptr->env_next)
					fprintf(fd,"env %f %f\n",eptr->env_val,
D 14
						(float) eptr->env_start.sft.l / Osize);
E 14
I 14
						(float) (eptr->env_start.sft.l -
						ptr->start.sft.l) / Osize);
E 14
					
E 13
E 12
E 10
E 8
E 5
		}
D 5
		if(ptr->flags & LP) fprintf(fd,"loop  Setup for looping\n");
		if(ptr->flags & PR) fprintf(fd,"precise mode selected\n");
E 5
I 5
		if(ptr->flags & LP) 
D 12
			fprintf(fd,"loop  Setup for looping\n");
E 12
I 12
			fprintf(fd,"loop until duration used up.\n");
E 12
		if(ptr->flags & PR) 
			fprintf(fd,"precise mode selected\n");
E 5
	}
	fprintf(fd,"< Globals\nsrate %f\nochans %d\n",srate,outchans);
I 9
D 11
	fprintf(fd,"< Globals\ngskip %f\ngdur %f\n",
D 10
			(float) gskip.l / (float) Osize,
			(float) gdur.l / (float) Osize);
E 10
I 10
			(float) gskip.sft.l / (float) Osize,
			(float) gdur.sft.l / (float) Osize);
E 11
I 11
D 12
	if(gskip)
		fprintf(fd,"gskip %f\n",(float) gskip.sft.l / (float) Osize,
	if(gdur)
		fprintf(fd,"gdur %f\n",(float) gdur.sft.l / (float) Osize,
E 12
I 12
	if(gskip.sft.l)
		fprintf(fd,"gskip %f\n",(float) gskip.sft.l / (float) Osize);
	if(gdur.sft.l)
		fprintf(fd,"gdur %f\n",(float) gdur.sft.l / (float) Osize);
E 12

I 12
	if(full)
		fprintf(fd,"full mix window\n");
E 12
E 11
E 10
E 9
D 5
	if(outfile[0] != '\0') fprintf(fd,"output %s\n",outfile);
E 5
I 5
	if(outfile[0] != '\0') 
		fprintf(fd,"output %s\n",outfile);
E 5
	fclose(fd);
}
E 1
