h32259
s 00002/00000/00265
d D 1.16 86/07/04 18:05:26 robert 16 15
c forgot sccs keywords
e
s 00001/00001/00264
d D 1.15 86/07/04 18:03:49 robert 15 14
c 
e
s 00003/00001/00262
d D 1.14 85/11/03 20:34:19 robert 14 13
c Added printout for memory and number of files used.
e
s 00006/00003/00257
d D 1.13 85/09/04 21:46:58 robert 13 12
c Working with CCSS.
e
s 00021/00001/00239
d D 1.12 85/09/02 20:29:00 robert 12 11
c Added 'full' keyword.
e
s 00011/00011/00229
d D 1.11 85/08/27 21:40:02 robert 11 10
c Version with input for samples.
e
s 00014/00000/00226
d D 1.10 85/07/29 13:07:15 robert 10 9
c Allowed for silence at end of file.
e
s 00013/00008/00213
d D 1.9 85/07/12 22:42:43 robert 9 8
c Added the 'mix' keyword.
e
s 00029/00019/00192
d D 1.8 85/06/28 21:45:35 robert 8 7
c Version for unlimited number of input UNIX files.
e
s 00052/00034/00159
d D 1.7 85/06/25 20:29:31 robert 7 6
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00075/00004/00118
d D 1.6 85/06/25 12:03:25 robert 6 5
c 4.2 working version for UNIX files.
e
s 00001/00001/00121
d D 1.5 84/07/18 22:07:55 robert 5 4
c MIXUNITS is in samples not bytes. 
e
s 00003/00000/00119
d D 1.4 84/05/16 15:09:53 robert 4 3
c Working (I think) version for exact mixing.
e
s 00001/00001/00118
d D 1.3 84/05/11 20:15:10 robert 3 2
c Don't use RAW mode as who knows what read and write are.
e
s 00004/00003/00115
d D 1.2 84/05/11 16:54:43 robert 2 1
c First version of exact sample mixing. Robert
e
s 00118/00000/00000
d D 1.1 82/12/08 08:37:39 robert 1 0
c date and time created 82/12/08 08:37:39 by robert
e
u
U
t
T
I 6
D 8
/* For now no gaps > blocksize */
E 8
D 7
#ifdef UNIXFILES
E 7
E 6
I 1
#include <stdio.h>
#include "mixer.h"
I 7
#ifdef UNIXFILES
E 7
I 6
#include <sys/file.h>
E 6

I 16
static char *sccs_id =  "%W%	%G%";

E 16
I 6
/* For play drivers that can do holes in files. */
#ifdef NOGAP
#include <sys/stat.h>
#endif
#endif UNIXFILES

I 12
long    action_time;

E 12
E 6
mixctl()
{
	/* Procedure to drive the mixer program through all of the soundfiles
	   adding or deleting from the run queue as needed */

D 12
	long    action_time = 0L;
E 12
	long    current_unit = 0L;
D 2
	int     unitnums;
E 2
I 2
	long     unitnums;
E 2
	register struct  SOUND_FILE *tempdq;
I 6
#ifdef UNIXFILES
	SFHEADER header;
D 7
	char *getsfname();
E 7
I 7
D 8
	char *sfname();
E 8
I 8
	char *getsfname();
E 8
E 7
#endif
E 6

I 12
	action_time = 0;
E 12
D 6
	fprintf(stderr,"MIX: Output file %s will be %f sampling rate and %d channels.\n",
	(outfile[0] == '\0' ? "" : outfile),srate,outchans);
E 6
I 6
	if(*outfile == NULL)
#ifndef UNIXFILES
		strcpy(outfile,"mixtest");
#else
D 7
		strcpy(outfile,getsfname("mixtest"));
E 7
I 7
D 8
		strcpy(outfile,sfname("mixtest",O_CREAT));
E 8
I 8
		strcpy(outfile,getsfname("mixtest"));
E 8
E 7
#endif
E 6

I 6
	fprintf(stderr,"MIX: Output file %s [%8.2f srate and %d channel(s)].\n",
D 14
	outfile,srate,outchans);
E 14
I 14
			outfile,srate,outchans);
E 14

E 6
I 4
	if(MIXUNIT != DMIXUNIT)
D 5
		fprintf(stderr,"Using buffers of %d bytes\n",MIXUNIT);
E 5
I 5
		fprintf(stderr,"Using buffers of %d samples\n",MIXUNIT);
E 5

E 4

	/* Get the input and output buffers - assume we need shorts in. */

D 7
	if((inint = (short *) malloc(sizeof(short) * MIXUNIT)) == NULL) nomemory();
E 7
I 7
D 9
	if((inint = (short *) malloc(sizeof(short) * MIXUNIT)) == NULL) 
		nomemory();
E 7
	if(foutput)   {
		outflt = (float *) malloc(sizeof(float) * MIXUNIT);
D 7
		if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) nomemory();
E 7
I 7
		if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
E 9
I 9
	if(!inint)
		if((inint = (short *) malloc(sizeof(short) * MIXUNIT)) == NULL) 
E 9
			nomemory();
I 9
	if(foutput)   {
		if(!outflt)
			outflt = (float *) malloc(sizeof(float) * MIXUNIT);
		if(!inflt)
			if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
				nomemory();
E 9
E 7
	}
	else
D 9
		outint = (short *) malloc(sizeof(short) * MIXUNIT);
E 9
I 9
		if(!outint)
			outint = (short *) malloc(sizeof(short) * MIXUNIT);
E 9
D 7
	if(!outflt && !outint) nomemory();
E 7

I 7
	if(!outflt && !outint) 
		nomemory();

E 7
	if(!inflt)
		for(tempdq = queue; tempdq; tempdq = tempdq->right_activate)  /* Float */
			if(tempdq->class == FLOAT) { /* Get a float buffer */
D 7
				if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) nomemory();
E 7
I 7
				if((inflt = (float *) malloc(sizeof(float) 
					* MIXUNIT)) == NULL) 
						nomemory();
E 7
				break;
			}

D 7
	if(mixer_flags & CKAMP) { /* Since CKAMP is implemented by forceing F.P. output buffer make sure we have one. */
		if(!foutput) if((outflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) nomemory();
		if(!inflt) if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) nomemory();
E 7
I 7
	if(mixer_flags & CKAMP) { /* CKAMP forces float buffer. */
		if(!foutput) 
D 9
			if((outflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
				nomemory();
E 9
I 9
			if(!outflt)
				if((outflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
					nomemory();
E 9
		if(!inflt) 
			if((inflt = (float *) malloc(sizeof(float) * MIXUNIT)) == NULL) 
				nomemory();
E 7
	}
I 14

	fprintf(stderr,"%dK memory and %d input files.\n", sbrk(0)/1024, inputfiles);
E 14

D 3
	if((outfd = sfcreat((foutput ? FLOAT : INT),SAMPLES,RAWSF(PRIVATE),srate,
E 3
I 3
	if((outfd = sfcreat((foutput ? FLOAT : INT),SAMPLES,PRIVATE,srate,
E 3
D 7
	outchans,"mixer",outfile)) == -1) {
E 7
I 7
		outchans,"mixer",outfile)) == -1) {
E 7
		errs.errnum = NOOUTPUT;
		mixerr();
	}

I 6
#ifdef UNIXFILES
D 8
	header.sfinfo.sf_magic = SF_MAGIC;
	header.sfinfo.sf_srate = srate;
	header.sfinfo.sf_chans = outchans;
	header.sfinfo.sf_packmode = foutput ? SF_FLOAT : SF_SHORT;
E 8
I 8
	sfmagic(&header) = SF_MAGIC;
	sfsrate(&header) = srate;
	sfchans(&header) = outchans;
	sfclass(&header) = foutput ? SF_FLOAT : SF_SHORT;
E 8
	if(wheader(outfd,&header)) {
		errs.errnum = NOOUTPUT; /* NOHEADER */
		mixerr();
	}
#endif
	
E 6

I 6

E 6
	savesfs();
	endptr=queue;
	while(queue) {
D 7
		if(endptr->filed == -1) { /* If we added a file that wasn't open */
E 7
I 7
D 8
		if(endptr->filed == -1) { /* open file */
E 7
			sfopn();
I 7

E 7
			/* Are there multiple starts? */
D 7
			while(endptr->right_activate && endptr->right_activate->start.l == endptr->start.l) {
				endptr = endptr->right_activate;
				sfopn();        /* open another */
E 7
I 7
			while(endptr->right_activate && 
				endptr->right_activate->start.l == endptr->start.l) {
					endptr = endptr->right_activate;
					sfopn();        /* open another */
E 7
			}
		}

E 8
D 11
		if(queue->start.l > current_unit) {  /* Found a gap */
I 6
			int distance = (queue->start.l - current_unit) *
E 11
I 11
		if(queue->start.sft.l > current_unit) {  /* Found a gap */
			int distance = (queue->start.sft.l - current_unit) *
E 11
				(long) (foutput ? FLOAT : INT);
#ifndef NOGAP
D 8
			fprintf(stderr,"Skipping %f seconds.\n",(float) (distance /
E 8
I 8
			fprintf(stderr,"Skipping %.4f seconds.\n",(float) (distance /
E 8
				(srate * outchans * (foutput ? SF_FLOAT : SF_SHORT)))); 
#else
			struct stat st;
I 13
			int zero = 0;
E 13
			int reset;
			reset = lseek(outfd,0,1);
			if(fstat(outfd,&st)) {
				errs.errnum = NOFDS;
				errs.str = "output";
				mixerr();
			}
			while(distance > st.st_blksize) { 
				if(sflseek(outfd,st.st_blksize-4,1) == -1) {
					errs.errnum = SKIP;
					errs.str = "output";
					mixerr();
				}
D 13
				/* just to be sure */
				st.st_spare1 = 0;
D 7
				if(write(outfd,&st.st_spare1,4) < 0) { /* force real block */
E 7
I 7
				if(write(outfd,&st.st_spare1,4) < 0) { 
E 13
I 13
				if(write(outfd,&zero,4) < 0) { 
E 13
E 7
					errs.errnum = SFWRITE;
					errs.str = outfile;
					mixerr();
				}
				distance -= st.st_blksize;
			}
			lseek(outfd,reset,0);
			fprintf(stderr,"\n");
#endif NOGAP
E 6
D 2
			if(sflseek(outfd,(queue->start.l - current_unit) * (long) MIXUNIT * (long) (foutput ? FLOAT : INT),1) == -1) {
E 2
I 2
D 7
			if(sflseek(outfd,(queue->start.l - current_unit) * (long)  (foutput ? FLOAT : INT),1) == -1) {
E 2
				errs.errnum = SKIP;
				errs.str = "output";
				mixerr();
E 7
I 7
D 11
			if(sflseek(outfd,(queue->start.l - current_unit) * 
E 11
I 11
			if(sflseek(outfd,(queue->start.sft.l - current_unit) * 
E 11
				(long)  (foutput ? FLOAT : INT),1) == -1) {
					errs.errnum = SKIP;
					errs.str = "output";
					mixerr();
E 7
			}
D 11
			current_unit = queue->start.l;
E 11
I 11
			current_unit = queue->start.sft.l;
E 11
I 6
#ifdef NOGAP
			/* in case we over shot */
			ftruncate(outfd,lseek(outfd,0,1));
#endif
E 6
			continue;     /* Back for more */
		}

I 8
		if(endptr->filed == -1) { /* open file */
#ifdef UNIXFILES
			sfopn(endptr,CANWAIT);
#else
			sfopn();
#endif

			/* Are there multiple starts? */
			while(endptr->right_activate && 
D 11
				endptr->right_activate->start.l == endptr->start.l) {
E 11
I 11
				endptr->right_activate->start.sft.l == endptr->start.sft.l) {
E 11
					endptr = endptr->right_activate;
#ifdef UNIXFILES
					sfopn(endptr,CANWAIT);        /* open another */
#else
					sfopn();        /* open another */
#endif
			}
		}
E 8
		/* Which is first? Start a file or finish one? 
			    What if they finish at the same time?   */

		if(endptr->right_activate &&
D 7
		    endptr->right_activate->start.l < dealloc_queue->end.l) action_time = endptr->right_activate->start.l;
E 7
I 7
D 11
		    endptr->right_activate->start.l < dealloc_queue->end.l) 
			action_time = endptr->right_activate->start.l;
E 11
I 11
		    endptr->right_activate->start.sft.l < dealloc_queue->end.sft.l) 
			action_time = endptr->right_activate->start.sft.l;
E 11
E 7
		else {
D 11
			action_time = dealloc_queue->end.l;
E 11
I 11
			action_time = dealloc_queue->end.sft.l;
E 11
			mixer_flags |= DELETE;
		}

I 12
		if(gdur.sft.l && gdur.sft.l < action_time) {
			action_time = gdur.sft.l;
			mixer_flags |= STOP;
		}

E 12
		/* Ok, ready to mix */
I 2
		/* Unitnums is in samples */
E 2

		unitnums = action_time - current_unit;
		if(unitnums) { /* As long as we didn't also need to add a file */
			setmode();          /* Set up if concrete or quick mode */
D 7
			if((mixer_flags & M_MODE) || (mixer_flags & CKAMP)) cmixem(endptr,unitnums,current_unit);
D 2
			else qmixem(endptr,unitnums);
E 2
I 2
			else qmixem(endptr,unitnums,current_unit);
E 7
I 7
			if((mixer_flags & M_MODE) || (mixer_flags & CKAMP)) 
				cmixem(endptr,unitnums,current_unit);
			else 
				qmixem(endptr,unitnums,current_unit);
E 7
E 2
		}

		/* Now we have run into the next action time */

I 12
		if(mixer_flags & STOP) { /* Close files and free memory. */
			struct SOUND_FILE *ptr;
			for(ptr = queue; ptr != endptr->right_activate;
				ptr = ptr->right_activate) 
I 13
#ifdef UNIXFILES
E 13
					sfcls(ptr,LETGO);
I 13
#else UNIXFILES
					sfcls(ptr);
#endif UNIXFILES
E 13
			for(ptr = queue; ptr; ptr = ptr->right_activate) 
				if(ptr->more)
					free((char *) ptr->more);
				free((char *) ptr);
			break;
		}
			
E 12
D 7
		if(mixer_flags & DELETE) /* Remove a file */
			while(dealloc_queue->end.l == action_time) { /* Multiple deletes? */
E 7
I 7
		if(mixer_flags & DELETE) /* Remove some files */
D 11
			while(dealloc_queue->end.l == action_time) { 
E 11
I 11
D 15
			while(dealloc_queue->end.sft.l == action_time) { 
E 15
I 15
			while(dealloc_queue && dealloc_queue->end.sft.l == action_time) { 
E 15
E 11
I 8
#ifdef UNIXFILES
				sfcls(dealloc_queue,LETGO); /* Close soundfile */
#else
E 8
E 7
				sfcls(dealloc_queue); /* Close soundfile */
I 8
#endif UNIXFILES
E 8
D 7
				if(dealloc_queue == queue) { /* Removing the head node */
E 7
I 7
				if(dealloc_queue == queue) { /* head node */
E 7
D 6
					if(endptr == queue) endptr = queue->right_activate; /* one file */
E 6
I 6
					if(endptr == queue) 
						endptr = queue->right_activate; /* one file */
E 6
					queue = queue->right_activate;
				}
				else { /* node in between */
D 7
					dealloc_queue->left_activate->right_activate = dealloc_queue->right_activate;
E 7
I 7
					dealloc_queue->left_activate->right_activate = 
						dealloc_queue->right_activate;
E 7
D 6
					dealloc_queue->right_activate->left_activate = dealloc_queue->left_activate;
E 6
I 6
					if(dealloc_queue->right_activate)
D 7
						dealloc_queue->right_activate->left_activate 
							= dealloc_queue->left_activate;
E 7
I 7
						dealloc_queue->right_activate->left_activate = 
							dealloc_queue->left_activate;
E 7
E 6
				}

				tempdq = dealloc_queue;
				dealloc_queue = dealloc_queue->deactivate;
D 7
				if(tempdq->more) free((char *) tempdq->more);
				free((char *) tempdq); /* Free up core */
E 7
I 7
				if(tempdq->more) 
					free((char *) tempdq->more);
				free((char *) tempdq);
E 7
				mixer_flags &= ~DELETE;
			}

		/* Not a delete */

D 7
		else if(endptr->right_activate) endptr = endptr->right_activate;
E 7
I 7
		else 
			if(endptr->right_activate) 
				endptr = endptr->right_activate;
E 7
		current_unit = action_time;        /* Reset */
	} /* While end */
I 12

E 12
I 10
D 11
	if(gdur.l > action_time) { /* Silence at end */
E 11
I 11
	if(gdur.sft.l > action_time) { /* Silence at end */
E 11
		int zero = 0;
D 11
		int distance = (gdur.l - current_unit) *
E 11
I 11
		int distance = (gdur.sft.l - current_unit) *
E 11
			(long) (foutput ? FLOAT : INT);

		sflseek(outfd,distance  - sizeof(int),1);
		fprintf(stderr,"Skipping %.4f seconds at end.\n",
			(float) (distance / (srate * outchans * 
				(foutput ? SF_FLOAT : SF_SHORT)))); 
		if(sfwrite(outfd,&zero,sizeof(int)) < sizeof(int)) {
			errs.errnum = SFWRITE;
			mixerr();
		}
	}
E 10
	sfclose(outfd);
}
D 7
/* End of mixctl.c */

E 7
E 1
