h29136
s 00005/00007/00084
d D 1.8 86/07/04 17:58:22 robert 8 7
c yocom followup: file duration is now reported in setup.c
e
s 00012/00001/00079
d D 1.7 86/07/03 17:06:34 yocom 7 6
c yocom edition: changed default channel assignments
e
s 00006/00006/00074
d D 1.6 85/08/27 21:39:37 robert 6 5
c Version with input for samples.
e
s 00000/00000/00080
d D 1.5 85/06/25 20:29:18 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00028/00005/00052
d D 1.4 85/06/25 12:03:06 robert 4 3
c 4.2 working version for UNIX files.
e
s 00000/00000/00057
d D 1.3 84/05/16 15:09:36 robert 3 2
c Working (I think) version for exact mixing.
e
s 00000/00000/00057
d D 1.2 84/05/11 16:54:30 robert 2 1
c First version of exact sample mixing. Robert
e
s 00057/00000/00000
d D 1.1 82/12/08 08:37:35 robert 1 0
c date and time created 82/12/08 08:37:35 by robert
e
u
U
t
T
I 1
# include <stdio.h>
# include "mixer.h"
# include <sys/stat.h>

I 8
static char *sccs_id =  "%W%	%G%";

E 8
install(new)
register struct SOUND_FILE *new;
{
	/* Procedure to put structure new on the queue in ascending time order */

	register struct SOUND_FILE *count;
D 4
	struct SFDESC sfd;
	struct stat st;
E 4
I 4
#ifndef UNIXFILES
	struct SFDESC sfdesc;
E 4
	short *cylptr;
I 4
#else
	int fd;
	SFHEADER header;
#endif
	struct stat statst;
E 4

D 6
	if(new->end.s <= 0) { /* Duration not specified, use all of it */
E 6
I 6
	if(new->end.sft.s <= 0) { /* Duration not specified, use all of it */
E 6
D 4
		if(sfstat(new->fname,&sfd,&st,&cylptr)) {
E 4
I 4
#ifdef UNIXFILES
		if((fd = open(new->fname,READ)) < 0) {
E 4
			errs.str = new->fname;
			errs.errnum = NOFILE;
			mixerr();
		}
D 4
		new->end.s = (float) sfd.sf_bsize / (sfd.sf_srate * (float)
		    (sfd.sf_class * sfd.sf_chans)) - new->offset.s;
E 4
I 4
		if(rheader(fd,&header)) {
			errs.str = new->fname;
			errs.errnum = NOFILE;
			mixerr();
		}
		close(fd);
		if(header.sfinfo.sf_magic != SF_MAGIC) {
			errs.str = new->fname;
			errs.errnum = SFTYPE;
			mixerr();
		}
#endif UNIXFILES
		if(sfstat(new->fname,&sfdesc,&statst,&cylptr)) {
			errs.str = new->fname;
			errs.errnum = NOFILE;
			mixerr();
		}
I 7

I 8
		new->end.sft.s = (float) SFBSIZE / (SFSRATE * (float)
		    (SFCLASS * SFCHANS)) - new->offset.sft.s;

E 8
/*
 * Default nr chans will be greatest found among files in the queue. 
 */
		if((SFCHANS > outchans) && !outflag)
			outchans = SFCHANS;
D 8

E 7
D 6
		new->end.s = (float) SFBSIZE / (SFSRATE * (float)
		    (SFCLASS * SFCHANS)) - new->offset.s;
E 4
		fprintf(stderr,"File %s duration is %f\n",new->fname,new->end.s);
E 6
I 6
		new->end.sft.s = (float) SFBSIZE / (SFSRATE * (float)
		    (SFCLASS * SFCHANS)) - new->offset.sft.s;
D 7
		fprintf(stderr,"File %s duration is %f\n",new->fname,new->end.sft.s);
E 7
I 7


		fprintf(stderr,"File %s duration is %f\n",
				new->fname,new->end.sft.s);
E 8

E 7
E 6
	}

	/* If the queue is null then put this one on the queue as head and last
		   and return. */

	if(queue == NULL) {
		queue = last = new;
		return;
	}

D 6
	if(new->start.s >= last->start.s) {   /* add to the end of the queue */
E 6
I 6
	if(new->start.sft.s >= last->start.sft.s) {   /* add to the end of the queue */
E 6
		last->right_activate = new;
		new->left_activate = last;
		last = new;
	}
	else /* linear search */
	for(count = queue; count; count = count->right_activate) {
D 6
		if(new->start.s <= count->start.s) { /* We found its slot */
E 6
I 6
		if(new->start.sft.s <= count->start.sft.s) { /* We found its slot */
E 6
			if(count == queue) { /* New head node is needed */
				new->right_activate = queue;
				queue->left_activate = new;
				queue = new;
			}
			else { /* Not a head node */
				new->left_activate = count->left_activate;
				new->right_activate = count;
				new->left_activate->right_activate = new;
				count->left_activate = new;
			}
			break;
		}     /* End of we found the slot */
	}
}

E 1
