/*	@(#)dsndac.c	1.3	9/2/85	IRCAM */
# include <carl/carl.h>
# include <sys/types.h>
# include <signal.h>
# include <carl/sndio.h>
# include <dsc.h>
# include <dsreg.h>
# include <sys/stat.h>
# include <stdio.h>
# include <sfheader.h>
# include "play.h"
# include <errno.h>

extern inthappened, errno, verbose;

# ifndef TRAKS
# define TRAKS	4
# endif  TRAKS

#define DSCDMA0 0
/* These are replaced by entries in sfstab */
#define DSCDSK0 0	/* index into device table in driver for /snd */
#define DSCDSK1 1	/* index into device table in driver for /snd1 */
/* from play.c */
extern int noplay;
extern int prompt;
extern int synchro;
extern int syncval;

char *waiter = "/dev/ttyh0";
int syncpid;

/* how many buffers */
# define UBSIZE		4

short *dsbuf;
long grepeat;

char ds[] = DEVDS0;

char *dserrs[] = {
	"missing arguments/parameters",
	"converters in use",
	"buffer size wasn't modulo bsize",
	"buffer size was too small",
	"disk error",
	"converter error",
	"dsreset clobbered us",
	"sync time out",
	""
};


dsdac(sfd, stbyte, nsamps, srate, filts, repeat, seq, blksize) 
	int sfd;
	long 	stbyte; 	/* starting sector address */
	long	nsamps; /* number of samples to convert */
	int	srate; 	/* sampling rate */
	int	filts; 	/* filter select */
	int	repeat; /* repeat count */
	short 	*seq;	/* converter address sequence */
	long	blksize; /* File system block size */
{
	struct ds_seq dsseq;
	struct ds_err dserr;
	struct ds_fs dsf;
	register int dacfid, cnt=0, erno;
	long *blkbuf;

	if(verbose) {
		printf("DSBYTE=%D ,DSCOUNT=%D ",
			stbyte,  nsamps * BP16BIT);
		printf("DSRATE=%O rep=%D ", srate, repeat);
		printf("filts=");
		switch (filts) {
		    case DS20KHZ:	printf("%d", ASC_HZ10>>1);	break;
		    case DS10KHZ:	printf("%d", ASC_HZ20>>1);	break;
		    case DSBYPAS:	printf("%d", ASC_BYPASS>>1); 	break;
		    case DS5KHZ:	printf("%d", ASC_HZ05>>1);
		}
		printf("\n");
	}

	if (nsamps < 1) {
		fprintf(stderr, "dsdac: can't convert 0 samples!\n"); 
		return(-1);
	}


	/* ds driver will use this buffer for sample data transfer */
	if (dsbuf == NULL)
		if ((dsbuf = (short *) valloc((unsigned) 
		    blksize * UBSIZE)) == NULL) {
			perror("valloc");
			return(1);
		}

	grepeat = repeat;	/* so a [DEL] can stop repeating */
	while (grepeat-- > 0) {
		cnt = 0;
		while ((dacfid = open(ds, 1)) < 0) {
			if (inthappened) {
				fprintf(stderr, "inthappened=%d, aborting.\n",
					inthappened);
				return(0);
			}
			if (errno != ENXIO) {	/* convs. failing? */
				perror("dsdac:open");
				return(-1);
			}
			if (!cnt) { 		/* ENXIO means in use */
				cnt++; 
				fprintf(stderr,
					"waiting for DACs to be available...");
			}
			sleep(4);
		}
		if (cnt) 
			fprintf(stderr, " gotcha!\n");


		if (setdsseq(dacfid, seq, 0)) 	/* set up sequence ram */
			{ close(dacfid); return(-1); }

		dsseq.dirt = srate;
		if (ioctl(dacfid, DSRATE, &dsseq) == -1) 
			{ perror("dsrate"); goto errout; }


		/* add filter params */
		if (ioctl(dacfid, filts, (struct ds_fs *) NULL) == -1) 
		    { perror("filts"); goto errout; } 

		/* amount of file to convert */
		sflseek(sfd,stbyte,0);
			if( verbose) 
				printf("lseek %d\n",stbyte);

		dsf.bnosiz = sfd;
		if (ioctl(dacfid, DS42BSD, &dsf) == -1) 
			{ perror("dsblks"); goto errout; }

		/* dsf.bnosiz = nsamps * BP16BIT;
		if (ioctl(dacfid, DSCOUNT, &dsf) == -1) 
			{ perror("dsbno"); goto errout; } */

		if(verbose) {
			printf("blksize = %d UBSIZE = %d\n",blksize,UBSIZE);
			printf("Using write of %d bytes\n",nsamps  * BP16BIT);
		}
#ifdef SYNC
		if (synchro) {
			if (ioctl(dacfid, DSSYNC, NULL) == -1)
				{ perror("dssync"); close(dacfid); return (1); }
			dsf.bnosiz = syncval;
			if (ioctl(dacfid, DSSYNCTIMEVAL, &dsf) == -1)
				{ perror("dssynctimeval"); close(dacfid); return (1); }
			/* Spawn a proccess that triggers the wait. */
			syncpid = waitfor(waiter);

			fprintf(stderr,"sync [pid %d] waiting (%d second timeout) . .",
				syncpid,syncval);
		}
#endif SYNC

		if (write(dacfid, (char *) dsbuf, nsamps * BP16BIT) == -1) {
		    if (!inthappened) {
			perror("write");
			if (ioctl(dacfid, DSERRS, &dserr) == -1) 
				{ perror("dserrs"); goto errout; }
			switch (dserr.errors) {
				case EDS_ARGS : erno = 0; break;
				case EDS_ACC : erno = 1; break;
				case EDS_MOD : erno = 2; break;
				case EDS_SIZE : erno = 3; break;
				case EDS_DISK : erno = 4; break;
				case EDS_CERR : erno = 5; break;
				case EDS_RST : erno = 6; break;
#ifdef SYNC
				case EDS_TIMEOUT : 
					erno = 7; 
					kill(syncpid,SIGTERM);
					break;
#endif SYNC
				default: erno = 8; break;
			}
			fprintf(stderr, "%s dmacsr=%o, asccsr=%o, errors=%o\n", 
				dserrs[erno], 
					dserr.dma_csr & ((u_short) -1), 
					dserr.asc_csr & ((u_short) -1),
					dserr.errors & ((u_short) -1));
		    }
		}
		if(close(dacfid))
			printf("Bad close\n");
	}
	free((char *) dsbuf);
	printf("!\n");
	return(0);

errout:
	free((char *) dsbuf);
	close(dacfid);
	return(1);
}
