/* Space display for vi550 terminal */
/* cc -O space.c -lv550 -lfrm -lm -o space */
#include <stdio.h>
#include <math.h>
#include <carl/frm.h>

#define XMIN 0
#define XMAX 767
#define YMIN 0
#define YMAX 584
#define PI2 (8.*atan(1.))
#define PI (4.*atan(1.))
#define OPEN	10
#define USAGE\
{\
fprintf(stderr, "\nSPACE Usage (Visual 550 only):\n");\
fprintf(stderr, " space\n");\
fprintf(stderr, "	[\n");\
fprintf(stderr, "	-iSize of inner room (4.)\n");\
fprintf(stderr, "	-cNchan (2)\n");\
fprintf(stderr, "	-d display direct paths\n");\
fprintf(stderr, "	-r display reflected paths\n");\
fprintf(stderr, "	-v x y theta(in deg) amp\n");\
fprintf(stderr, "	]\n");\
exit();\
}

/* current screen coordinates */
double sxmin= 0., sxmax= 1., 
      symin= 1., symax= 0.;
/* locate current window within screen coordinates */
double wxmin= .26/2., wxmax= 1.-.26/2.,	/* aspect ratio correction */
      wymin= 0., wymax= .9;
/* current plot range coordinates */
double rxmin= -50., rxmax= 50.,
      rymin= 50., rymax= -50.;

int Nchan = 2;
/* Spatial Globals */
float Lx[]={4.,-4.,-4.,4.}; /* Listening space x-coordinates */
float Ly[]={4.,4.,-4.,-4.}; /* Listening space y-coordinates */
int   NLs = 4;		/* Number of listening surfaces */
float Ax[]={50.,-50.,-50.,50.};	/* Acoustic space x-coordinates */
float Ay[]={50.,50.,-50.,-50};	/* Acoustic space y-coordinates */
int   NAs = 4;		/* Number of acoustic space surfaces */
float Sx[]={4.,-4.,-4.,4.}; /* Speaker x-coordinates */
float Sy[]={4.,4.,-4.,-4.}; /* Speaker y-coordinates */

main(argc, argv) int argc; char *argv[];
{
 double wx, wy, t, rx[5], ry[5], theta[5], amp[5], interp();
 int i, j, nrv=0, r, s, c, direct = 0, reflect = 0;
 char buf[1000], tmp[1000];

    if(argc == 1)USAGE;
    for(i = 1; i < argc; i++){
	if(*argv[i] != '-')USAGE;
	switch(*(++argv[i])){
	    case 'i': t = expr(++argv[i]); 
			Lx[0] = t; Lx[1] = -t; Lx[2] = -t; Lx[3] =  t;
			Ly[0] = t; Ly[1] = t; Ly[2] = -t; Ly[3] =  -t;
			for(j=0; j<4; j++){Sx[j] = Lx[j]; Sy[j] = Ly[j];}
			break;
	    case 'c': Nchan = expr(++argv[i]); break;
	    case 'd': direct = 1; break;
	    case 'r': reflect = 1; break;
	    case 'v': rx[nrv] = expr(argv[++i]);
			ry[nrv] = expr(argv[++i]);
			theta[nrv] = expr(argv[++i])*PI2/360.;
			amp[nrv] = expr(argv[++i]);
			nrv++;
		      break;
	}
    }
    openpl();
    erase();
    windowbox();
    inner();
    for(r=0; r<nrv; r++){
	line(px(rx[r]), py(ry[r]), 
	    px(amp[r]*cos(theta[r])+rx[r]), py(amp[r]*sin(theta[r])+ry[r]) );
	circle(px(rx[r]), py(ry[r]), OPEN/2);
    }
    if(direct)for(r=0; r<nrv; r++)
     for(c=0; c<Nchan; c++){
	line(px(rx[r]),py(ry[r]),px(Sx[c]),py(Sy[c]));
    }
    if(reflect){
	linemod("dotted");
	for(r=0; r<nrv; r++)
	 for(s=0; s<4; s++)
	  for(c=0; c<Nchan; c++){
	    getrefl(rx[r],ry[r],Sx[c],Sy[c],s,&wx,&wy);
	    line(px(rx[r]),py(ry[r]),px(wx),py(wy));
	    line(px(wx),py(wy),px(Sx[c]),py(Sy[c]));
	}
    }
    move(XMIN, YMIN+40);
    sprintf(buf,"%d Channels; Room Sizes: outer = %.0f, inner = %.0f",
	Nchan, Ax[0], Lx[0]);
    if(nrv) {
	sprintf(tmp,"; %d Sound Paths Calculated",
	direct*Nchan*nrv+reflect*Nchan*nrv*4);
	strcat(buf,tmp);
    }
    label(buf);
    if(nrv){
	move(XMIN, YMIN);
	sprintf(buf,"%d Radiation Vector(s):", nrv);
	for(r=0; r<nrv; r++){
	    sprintf(tmp," (%.0f,%.0f,%.0f,%.0f)",
		rx[r],ry[r],theta[r]*360./PI2,amp[r]);
	    strcat(buf, tmp);
	}
	label(buf);
    }
    move(0,0);
    closepl();
}
windowbox(){
    move(wx(wxmin),wy(wymin));
    cont(wx(wxmax),wy(wymin));
    cont(wx(wxmax),wy(wymax));
    cont(wx(wxmin),wy(wymax));
    cont(wx(wxmin),wy(wymin));
}
inner() {
 int i;
 int r;
    for(i=0; i<4; i++) 
	line(px(Lx[i]), py(Ly[i]), px(Lx[(i+1)%4]), py(Ly[(i+1)%4]) );
    for(i=0; i<4; i++) 
	line(px(Lx[i])+1, py(Ly[i]), px(Lx[(i+1)%4])+1, py(Ly[(i+1)%4]) );
    for(i=0; i<4; i++) 
	line(px(Lx[i]), py(Ly[i])+1, px(Lx[(i+1)%4]), py(Ly[(i+1)%4])+1 );
    r = (px(Lx[1]) - px(Lx[0]))/10; r = r > 0 ? r : -r ;
    for(i=0; i<Nchan; i++)circle(px(Sx[i]), py(Sy[i]),r);
}

double interp(x, xmin, xmax, omin, omax) double x, xmin, xmax, omin, omax; {
    return( (x - xmin)*(omax - omin)/(xmax - xmin) + omin );
}
sx(x) double x; { /* screen to absolute */
 double interp();
    return( (int) interp(x, sxmin, sxmax, (double) XMIN, (double) XMAX) );
}
sy(y) double y; { /* screen to absolute */
    return( (int) interp(y, symin, symax, (double) YMIN, (double) YMAX) );
}
wx(x) double x; { /* window to absolute */
    return( sx(interp(x, wxmin, wxmax, wxmin, wxmax) ) );
}
wy(y) double y; { /* window to absolute */
    return( sy(interp(y, wymin, wymax, wymin, wymax) ) );
}
px(x) double x; { /* ranged data to absolute with window within screen */
 double interp();
    return( sx( interp(x, rxmin, rxmax, wxmin, wxmax) ) );
}
py(y) double y; { /* ranged data to absolute with window within screen */
 double interp();
    return( sy( interp(y, rymin, rymax, wymin, wymax) ) );
}
/*
 * getrefl calculates the reflection point (rx,ry) of a ray path from
 * source point (sx,sy) to surface s and back to channel output at (cx,cy)
 */
getrefl(sx,sy,cx,cy,s,rx,ry)
 double sx,sy,cx,cy,*rx,*ry; int s;
{
 double lx1,lx2,ly1,ly2,d2,s2,c2,r2,x,y,a;
 double dx1, dy1, dx2, dy2, m1, m2, b1, b2;
 static double d[]={0.,0.,0.,0.}, sint[4],cost[4],rho[4],sin2t[4],cos2t[4],
 f1[4], f2[4];

    s = s%NAs;
    lx1 = Ax[s];
    ly1 = Ay[s];
    lx2 = Ax[(s+1)%NAs];
    ly2 = Ay[(s+1)%NAs];
    if(d[s] == 0.){
	d[s] = 1./sqrt( (lx2-lx1)*(lx2-lx1) + (ly2-ly1)*(ly2-ly1) );
	sint[s] = (ly2-ly1)*d[s];
	cost[s] = (lx2-lx1)*d[s];
	rho[s] = ly1*cost[s] - lx1*sint[s];
	if(rho[s]>0.){sint[s]= -sint[s]; cost[s]= -cost[s]; rho[s]= -rho[s]; }
	sin2t[s] = 2.*sint[s]*cost[s];
	cos2t[s] = 2.*cost[s]*cost[s] - 1.;
	f1[s] = -2.*rho[s]*sint[s];
	f2[s] =  2.*rho[s]*cost[s];
    }
    x = f1[s] + sy*sin2t[s] + sx*cos2t[s];
    y = f2[s] - sy*cos2t[s] + sx*sin2t[s];

/*
 *     d2 = 1./sqrt( (x-cx)*(x-cx) + (y-cy)*(y-cy) );
 *     s2 = (y-cy)*d2;
 *     c2 = (x-cx)*d2;
 *     r2 = y*c2 - x*s2;
 *     if(r2>0.){s2= -s2; c2= -c2; r2= -r2;}
 *     a = 1./(sint[s]*c2 - cost[s]*s2);
 *     dy1 = (r2*sint[s] - rho[s]*s2)*a;
 *     dx1 = (r2*cost[s] - rho[s]*c2)*a;
 */

    dx1 = x - cx; 
    if(dx1){ dy1 = y - cy; m1 = dy1/dx1; b1 = y - m1*x; }
    dx2 = lx2 - lx1;
    if(dx2){ dy2 = ly2 - ly1; m2 = dy2/dx2; b2 = ly1 - m2*lx1; }
    if(!dx2){ *ry = m1*lx1+b1; *rx = lx1; return; }
    if(!dx1){ *ry = m2*x+b2; *rx = cx; return; }
    *rx = (b2-b1)/(m1-m2); *ry = m1*(*rx) + b1; return;
}
